/* Message constants
*
* by the AMX Mod X Development Team
*
* This file is provided as is (no warranties).
*
*/
 
#if defined _message_const_included
	#endinput
#endif
#define _message_const_included

/* Destination types for message_begin() */
#define	MSG_BROADCAST               0        // Unreliable to all
#define	MSG_ONE                     1        // Reliable to one (msg_entity)
#define	MSG_ALL                     2        // Reliable to all
#define	MSG_INIT                    3        // Write to the init string
#define MSG_PVS                     4        // Ents in PVS of org
#define MSG_PAS                     5        // Ents in PAS of org
#define MSG_PVS_R                   6        // Reliable to PVS
#define MSG_PAS_R                   7        // Reliable to PAS
#define MSG_ONE_UNRELIABLE          8        // Send to one client, but don't put in reliable stream, put in unreliable datagram (could be dropped)
#define	MSG_SPEC                    9        // Sends to all spectator proxies

/* Message types for message_begin() */
#define SVC_TEMPENTITY              23
#define SVC_INTERMISSION            30
#define SVC_CDTRACK                 32
#define SVC_WEAPONANIM              35
#define SVC_ROOMTYPE                37
#define SVC_ADDANGLE                38       // [vec3] add this angle to the view angle
#define SVC_NEWUSERMSG              39
#define	SVC_HLTV                    50

/* Message flags for set_msg_block() */
#define BLOCK_NOT                   0
#define BLOCK_ONCE                  1
#define BLOCK_SET                   2

/* Used with get_msg_argtype() and set_msg_arg_ */
enum
{
	ARG_BYTE = 1,       /* int */
	ARG_CHAR,           /* int */
	ARG_SHORT,          /* int */
	ARG_LONG,           /* int */
	ARG_ANGLE,          /* float */
	ARG_COORD,          /* float */
	ARG_STRING,         /* string */
	ARG_ENTITY,         /* int */
}

/* Temp entity message types for message_begin() */
#define	TE_BEAMPOINTS               0        // Beam effect between two points
// write_byte(TE_BEAMPOINTS)
// write_coord(startposition.x)
// write_coord(startposition.y)
// write_coord(startposition.z)
// write_coord(endposition.x)
// write_coord(endposition.y)
// write_coord(endposition.z)
// write_short(sprite index) 
// write_byte(starting frame) 
// write_byte(frame rate in 0.1's) 
// write_byte(life in 0.1's) 
// write_byte(line width in 0.1's) 
// write_byte(noise amplitude in 0.01's) 
// write_byte(red)
// write_byte(green)
// write_byte(blue)
// write_byte(brightness)
// write_byte(scroll speed in 0.1's)

#define	TE_BEAMENTPOINT             1        // Beam effect between point and entity
// write_byte(TE_BEAMENTPOINT)
// write_short(start entity) 
// write_coord(endposition.x)
// write_coord(endposition.y)
// write_coord(endposition.z)
// write_short(sprite index) 
// write_byte(starting frame) 
// write_byte(frame rate in 0.1's) 
// write_byte(life in 0.1's) 
// write_byte(line width in 0.1's) 
// write_byte(noise amplitude in 0.01's) 
// write_byte(red)
// write_byte(green)
// write_byte(blue)
// write_byte(brightness)
// write_byte(scroll speed in 0.1's)

#define	TE_GUNSHOT                  2        // Particle effect plus ricochet sound
// write_byte(TE_GUNSHOT)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)

#define	TE_EXPLOSION                3        // Additive sprite, 2 dynamic lights, flickering particles, explosion sound, move vertically 8 pps
// write_byte(TE_EXPLOSION)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_short(sprite index)
// write_byte(scale in 0.1's)
// write_byte(framerate)
// write_byte(flags)
//
// The Explosion effect has some flags to control performance/aesthetic features:
#define TE_EXPLFLAG_NONE            0        // All flags clear makes default Half-Life explosion
#define TE_EXPLFLAG_NOADDITIVE      1        // Sprite will be drawn opaque (ensure that the sprite you send is a non-additive sprite)
#define TE_EXPLFLAG_NODLIGHTS       2        // Do not render dynamic lights
#define TE_EXPLFLAG_NOSOUND         4        // Do not play client explosion sound
#define TE_EXPLFLAG_NOPARTICLES     8        // Do not draw particles

#define	TE_TAREXPLOSION             4        // Quake1 "tarbaby" explosion with sound
// write_byte(TE_TAREXPLOSION)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)

#define	TE_SMOKE                    5        // Alphablend sprite, move vertically 30 pps
// write_byte(TE_SMOKE)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z) 
// write_short(sprite index)
// write_byte(scale in 0.1's)
// write_byte(framerate)

#define	TE_TRACER                   6        // Tracer effect from point to point
// write_byte(TE_TRACER)
// write_coord(startposition.x)
// write_coord(startposition.y)
// write_coord(startposition.z)
// write_coord(endposition.x)
// write_coord(endposition.y)
// write_coord(endposition.z)

#define	TE_LIGHTNING                7        // TE_BEAMPOINTS with simplified parameters
// write_byte(TE_LIGHTNING)
// write_coord(startposition.x)
// write_coord(startposition.y)
// write_coord(startposition.z)
// write_coord(endposition.x)
// write_coord(endposition.y)
// write_coord(endposition.z)
// write_byte(life in 0.1's) 
// write_byte(width in 0.1's) 
// write_byte(amplitude in 0.01's)
// write_short(sprite model index)

#define	TE_BEAMENTS                 8
// write_byte(TE_BEAMENTS)
// write_short(start entity) 
// write_short(end entity) 
// write_short(sprite index) 
// write_byte(starting frame) 
// write_byte(frame rate in 0.1's) 
// write_byte(life in 0.1's) 
// write_byte(line width in 0.1's) 
// write_byte(noise amplitude in 0.01's) 
// write_byte(red)
// write_byte(green)
// write_byte(blue)
// write_byte(brightness)
// write_byte(scroll speed in 0.1's)

#define	TE_SPARKS                   9        // 8 random tracers with gravity, ricochet sprite
// write_byte(TE_SPARKS)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z) 

#define	TE_LAVASPLASH               10       // Quake1 lava splash
// write_byte(TE_LAVASPLASH)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)

#define	TE_TELEPORT                 11       // Quake1 teleport splash
// write_byte(TE_TELEPORT)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)

#define TE_EXPLOSION2               12       // Quake1 colormaped (base palette) particle explosion with sound
// write_byte(TE_EXPLOSION2)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_byte(starting color)
// write_byte(num colors)

#define TE_BSPDECAL                 13       // Decal from the .BSP file
// write_byte(TE_BSPDECAL)
// write_coord(position.x) decal position (center of texture in world)
// write_coord(position.y)
// write_coord(position.z)
// write_short(texture index of precached decal texture name)
// write_short(entity index)
// [optional - write_short(index of model of above entity) only included if previous short is non-zero (not the world)]

#define TE_IMPLOSION                14       // Tracers moving toward a point
// write_byte(TE_IMPLOSION)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_byte(radius)
// write_byte(count)
// write_byte(life in 0.1's) 

#define TE_SPRITETRAIL              15       // Line of moving glow sprites with gravity, fadeout, and collisions
// write_byte(TE_SPRITETRAIL)
// write_coord(startposition.x)
// write_coord(startposition.y)
// write_coord(startposition.z)
// write_coord(endposition.x)
// write_coord(endposition.y)
// write_coord(endposition.z)
// write_short(sprite index)
// write_byte(count)
// write_byte(life in 0.1's) 
// write_byte(scale in 0.1's) 
// write_byte(velocity along vector in 10's)
// write_byte(randomness of velocity in 10's)

#define TE_SPRITE                   17       // Additive sprite, plays 1 cycle
// write_byte(TE_SPRITE)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_short(sprite index) 
// write_byte(scale in 0.1's) 
// write_byte(brightness)

#define TE_BEAMSPRITE               18       // A beam with a sprite at the end
// write_byte(TE_BEAMSPRITE)
// write_coord(startposition.x)
// write_coord(startposition.y)
// write_coord(startposition.z)
// write_coord(endposition.x)
// write_coord(endposition.y)
// write_coord(endposition.z) 
// write_short(beam sprite index) 
// write_short(end sprite index) 

#define TE_BEAMTORUS                19       // Screen aligned beam ring, expands to max radius over lifetime
// write_byte(TE_BEAMTORUS)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_coord(axis.x)
// write_coord(axis.y)
// write_coord(axis.z) 
// write_short(sprite index) 
// write_byte(starting frame) 
// write_byte(frame rate in 0.1's) 
// write_byte(life in 0.1's) 
// write_byte(line width in 0.1's) 
// write_byte(noise amplitude in 0.01's) 
// write_byte(red)
// write_byte(green)
// write_byte(blue)
// write_byte(brightness)
// write_byte(scroll speed in 0.1's)

#define TE_BEAMDISK                 20       // Disk that expands to max radius over lifetime
// write_byte(TE_BEAMDISK)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_coord(axis.x)
// write_coord(axis.y)
// write_coord(axis.z) 
// write_short(sprite index) 
// write_byte(starting frame) 
// write_byte(frame rate in 0.1's) 
// write_byte(life in 0.1's) 
// write_byte(line width in 0.1's) 
// write_byte(noise amplitude in 0.01's) 
// write_byte(red)
// write_byte(green)
// write_byte(blue)
// write_byte(brightness)
// write_byte(scroll speed in 0.1's)

#define TE_BEAMCYLINDER             21       // Cylinder that expands to max radius over lifetime
// write_byte(TE_BEAMCYLINDER)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_coord(axis.x)
// write_coord(axis.y)
// write_coord(axis.z) 
// write_short(sprite index) 
// write_byte(starting frame) 
// write_byte(frame rate in 0.1's) 
// write_byte(life in 0.1's) 
// write_byte(line width in 0.1's) 
// write_byte(noise amplitude in 0.01's) 
// write_byte(red)
// write_byte(green)
// write_byte(blue)
// write_byte(brightness)
// write_byte(scroll speed in 0.1's)

#define TE_BEAMFOLLOW               22       // Create a line of decaying beam segments until entity stops moving
// write_byte(TE_BEAMFOLLOW)
// write_short(entity:attachment to follow)
// write_short(sprite index)
// write_byte(life in 0.1's) 
// write_byte(line width in 0.1's) 
// write_byte(red)
// write_byte(green)
// write_byte(blue)
// write_byte(brightness)

#define TE_GLOWSPRITE               23
// write_byte(TE_GLOWSPRITE)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_short(model index)
// write_byte(scale / 10)

#define TE_BEAMRING                 24       // Connect a beam ring to two entities
// write_byte(TE_BEAMRING)
// write_short(start entity) 
// write_short(end entity) 
// write_short(sprite index) 
// write_byte(starting frame) 
// write_byte(frame rate in 0.1's) 
// write_byte(life in 0.1's) 
// write_byte(line width in 0.1's) 
// write_byte(noise amplitude in 0.01's) 
// write_byte(red)
// write_byte(green)
// write_byte(blue)
// write_byte(brightness)
// write_byte(scroll speed in 0.1's)

#define TE_STREAK_SPLASH            25       // Oriented shower of tracers
// write_byte(TE_STREAK_SPLASH)
// write_coord(startposition.x)
// write_coord(startposition.y)
// write_coord(startposition.z)
// write_coord(vector.x)
// write_coord(vector.y)
// write_coord(vector.z) 
// write_byte(color)
// write_short(count)
// write_short(base speed)
// write_short(ramdon velocity)

#define TE_DLIGHT                   27       // Dynamic light, effect world, minor entity effect
// write_byte(TE_DLIGHT)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_byte(radius in 10's) 
// write_byte(red)
// write_byte(green)
// write_byte(blue)
// write_byte(brightness)
// write_byte(life in 10's)
// write_byte(decay rate in 10's)

#define TE_ELIGHT                   28       // Point entity light, no world effect
// write_byte(TE_ELIGHT)
// write_short(entity:attachment to follow)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_coord(radius)
// write_byte(red)
// write_byte(green)
// write_byte(blue)
// write_byte(life in 0.1's)
// write_coord(decay rate)

#define TE_TEXTMESSAGE              29
// write_byte(TE_TEXTMESSAGE)
// write_byte(channel)
// write_short(x) -1 = center)
// write_short(y) -1 = center)
// write_byte(effect) 0 = fade in/fade out, 1 is flickery credits, 2 is write out (training room)
// write_byte(red) - text color
// write_byte(green)
// write_byte(blue)
// write_byte(alpha)
// write_byte(red) - effect color
// write_byte(green)
// write_byte(blue)
// write_byte(alpha)
// write_short(fadein time)
// write_short(fadeout time)
// write_short(hold time)
// [optional] write_short(fxtime) time the highlight lags behing the leading text in effect 2
// write_string(text message) 512 chars max string size

#define TE_LINE                     30
// write_byte(TE_LINE)
// write_coord(startposition.x)
// write_coord(startposition.y)
// write_coord(startposition.z)
// write_coord(endposition.x)
// write_coord(endposition.y)
// write_coord(endposition.z)
// write_short(life in 0.1 s)
// write_byte(red)
// write_byte(green)
// write_byte(blue)

#define TE_BOX                      31
// write_byte(TE_BOX)
// write_coord(boxmins.x)
// write_coord(boxmins.y)
// write_coord(boxmins.z)
// write_coord(boxmaxs.x)
// write_coord(boxmaxs.y)
// write_coord(boxmaxs.z)
// write_short(life in 0.1 s)
// write_byte(red)
// write_byte(green)
// write_byte(blue)

#define TE_KILLBEAM                 99       // Kill all beams attached to entity
// write_byte(TE_KILLBEAM)
// write_short(entity)

#define TE_LARGEFUNNEL              100
// write_byte(TE_LARGEFUNNEL)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_short(sprite index) 
// write_short(flags) 

#define	TE_BLOODSTREAM              101      // Particle spray
// write_byte(TE_BLOODSTREAM)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_coord(vector.x)
// write_coord(vector.y)
// write_coord(vector.z)
// write_byte(color)
// write_byte(speed)

#define	TE_SHOWLINE                 102      // Line of particles every 5 units, dies in 30 seconds
// write_byte(TE_SHOWLINE)
// write_coord(startposition.x)
// write_coord(startposition.y)
// write_coord(startposition.z)
// write_coord(endposition.x)
// write_coord(endposition.y)
// write_coord(endposition.z)

#define TE_BLOOD                    103      // Particle spray
// write_byte(TE_BLOOD)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_coord(vector.x)
// write_coord(vector.y)
// write_coord(vector.z)
// write_byte(color)
// write_byte(speed)

#define TE_DECAL                    104      // Decal applied to a brush entity (not the world)
// write_byte(TE_DECAL)
// write_coord(position.x) decal position (center of texture in world)
// write_coord(position.y)
// write_coord(position.z)
// write_byte(texture index of precached decal texture name)
// write_short(entity index)

#define TE_FIZZ                     105      // Create alpha sprites inside of entity, float upwards
// write_byte(TE_FIZZ)
// write_short(entity)
// write_short(sprite index)
// write_byte density)

#define TE_MODEL                    106      // Create a moving model that bounces and makes a sound when it hits
// write_byte(TE_MODEL)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_coord(velocity.x)
// write_coord(velocity.y)
// write_coord(velocity.z)
// write_angle(initial yaw)
// write_short(model index)
// write_byte(bounce sound type)
// write_byte(life in 0.1's)

#define TE_EXPLODEMODEL             107      // Spherical shower of models, picks from set
// write_byte(TE_EXPLODEMODEL)
// write_coord(origin.x)
// write_coord(origin.y)
// write_coord(origin.z)
// write_coord(velocity.x)
// write_coord(velocity.y)
// write_coord(velocity.z)
// write_short(model index)
// write_short(count)
// write_byte(life in 0.1's)

#define TE_BREAKMODEL               108      // Box of models or sprites
// write_byte(TE_BREAKMODEL)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_coord(size.x)
// write_coord(size.y)
// write_coord(size.z)
// write_coord(velocity.x)
// write_coord(velocity.y)
// write_coord(velocity.z)
// write_byte(random velocity in 10's)
// write_short(sprite or model index)
// write_byte(count)
// write_byte(life in 0.1 secs)
// write_byte(flags)

#define TE_GUNSHOTDECAL             109      // Decal and ricochet sound
// write_byte(TE_GUNSHOTDECAL)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_short(entity index???)
// write_byte(decal???)

#define TE_SPRITE_SPRAY             110      // Spray of alpha sprites
// write_byte(TE_SPRITE_SPRAY)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_coord(velocity.x)
// write_coord(velocity.y)
// write_coord(velocity.z)
// write_short(sprite index)
// write_byte(count)
// write_byte(speed)
// write_byte(noise)

#define TE_ARMOR_RICOCHET           111      // Quick spark sprite, client ricochet sound.
// write_byte(TE_ARMOR_RICOCHET)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_byte(scale in 0.1's)

#define TE_PLAYERDECAL              112
// write_byte(TE_PLAYERDECAL)
// write_byte(playerindex)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_short(entity???)
// write_byte(decal number)
// [optional] write_short(model index)

#define TE_BUBBLES                  113      // Create alpha sprites inside of box, float upwards
// write_byte(TE_BUBBLES)
// write_coord(position.x) (min start position)
// write_coord(position.y)
// write_coord(position.z)
// write_coord(position.x) (max start position)
// write_coord(position.y)
// write_coord(position.z)
// write_coord(float height)
// write_short(model index)
// write_byte(count)
// write_coord(speed)

#define TE_BUBBLETRAIL              114      // Create alpha sprites along a line, float upwards
// write_byte(TE_BUBBLETRAIL)
// write_coord(position.x) (min start position)
// write_coord(position.y) (min start position)
// write_coord(position.z) (min start position)
// write_coord(position.x) (max start position)
// write_coord(position.y) (max start position)
// write_coord(position.z) (max start position)
// write_coord(float height)
// write_short(model index)
// write_byte(count)
// write_coord(speed)

#define TE_BLOODSPRITE              115      // Spray of opaque sprite1's that fall, single sprite2 for 1..2 secs (this is a high-priority tent)
// write_byte(TE_BLOODSPRITE)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_short(sprite1 index)
// write_short(sprite2 index)
// write_byte(color)
// write_byte(scale)

#define TE_WORLDDECAL               116      // Decal applied to the world brush
// write_byte(TE_WORLDDECAL)
// write_coord(position.x) decal position (center of texture in world)
// write_coord(position.y)
// write_coord(position.z)
// write_byte(texture index of precached decal texture name)

#define TE_WORLDDECALHIGH           117      // Decal (with texture index > 256) applied to world brush
// write_byte(TE_WORLDDECALHIGH)
// write_coord(position.x) decal position (center of texture in world)
// write_coord(position.y)
// write_coord(position.z)
// write_byte(texture index of precached decal texture name - 256)

#define TE_DECALHIGH                118      // Same as TE_DECAL, but the texture index was greater than 256
// write_byte(TE_DECALHIGH)
// write_coord(position.x) decal position (center of texture in world)
// write_coord(position.y)
// write_coord(position.z)
// write_byte(texture index of precached decal texture name - 256)
// write_short(entity index)

#define TE_PROJECTILE               119      // Makes a projectile (like a nail) (this is a high-priority tent)
// write_byte(TE_PROJECTILE)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_coord(velocity.x)
// write_coord(velocity.y)
// write_coord(velocity.z)
// write_short(modelindex)
// write_byte(life)
// write_byte(owner)  projectile won't collide with owner (if owner == 0, projectile will hit any client).

#define TE_SPRAY                    120      // Throws a shower of sprites or models
// write_byte(TE_SPRAY)
// write_coord(position.x)
// write_coord(position.y)
// write_coord(position.z)
// write_coord(direction.x)
// write_coord(direction.y)
// write_coord(direction.z)
// write_short(modelindex)
// write_byte(count)
// write_byte(speed)
// write_byte(noise)
// write_byte(rendermode)

#define TE_PLAYERSPRITES            121      // Sprites emit from a player's bounding box (ONLY use for players!)
// write_byte(TE_PLAYERSPRITES)
// write_byte(playernum)
// write_short(sprite modelindex)
// write_byte(count)
// write_byte(variance) (0 = no variance in size) (10 = 10% variance in size)

#define TE_PARTICLEBURST            122      // Very similar to lavasplash
// write_byte(TE_PARTICLEBURST)
// write_coord(origin)
// write_short(radius)
// write_byte(particle color)
// write_byte(duration * 10) (will be randomized a bit)

#define TE_FIREFIELD                123      // Makes a field of fire
// write_byte(TE_FIREFIELD)
// write_coord(origin)
// write_short(radius) (fire is made in a square around origin. -radius, -radius to radius, radius)
// write_short(modelindex)
// write_byte(count)
// write_byte(flags)
// write_byte(duration (in seconds) * 10) (will be randomized a bit)
//
// to keep network traffic low, this message has associated flags that fit into a byte:
#define TEFIRE_FLAG_ALLFLOAT        1        // All sprites will drift upwards as they animate
#define TEFIRE_FLAG_SOMEFLOAT       2        // Some of the sprites will drift upwards. (50% chance)
#define TEFIRE_FLAG_LOOP            4        // If set, sprite plays at 15 fps, otherwise plays at whatever rate stretches the animation over the sprite's duration.
#define TEFIRE_FLAG_ALPHA           8        // If set, sprite is rendered alpha blended at 50% else, opaque
#define TEFIRE_FLAG_PLANAR          16       // If set, all fire sprites have same initial Z instead of randomly filling a cube. 

#define TE_PLAYERATTACHMENT         124      // Attaches a TENT to a player (this is a high-priority tent)
// write_byte(TE_PLAYERATTACHMENT)
// write_byte(entity index of player)
// write_coord(vertical offset) (attachment origin.z = player origin.z + vertical offset)
// write_short(model index)
// write_short(life * 10 )

#define TE_KILLPLAYERATTACHMENTS    125      // Will expire all TENTS attached to a player.
// write_byte(TE_KILLPLAYERATTACHMENTS)
// write_byte(entity index of player)

#define TE_MULTIGUNSHOT             126      // Much more compact shotgun message
// This message is used to make a client approximate a 'spray' of gunfire.
// Any weapon that fires more than one bullet per frame and fires in a bit of a spread is
// a good candidate for MULTIGUNSHOT use. (shotguns)
//
// NOTE: This effect makes the client do traces for each bullet, these client traces ignore
//		 entities that have studio models.Traces are 4096 long.
//
// write_byte(TE_MULTIGUNSHOT)
// write_coord(origin.x)
// write_coord(origin.y)
// write_coord(origin.z)
// write_coord(direction.x)
// write_coord(direction.y)
// write_coord(direction.z)
// write_coord(x noise * 100)
// write_coord(y noise * 100)
// write_byte(count)
// write_byte(bullethole decal texture index)

#define TE_USERTRACER               127      // Larger message than the standard tracer, but allows some customization.
// write_byte(TE_USERTRACER)
// write_coord(origin.x)
// write_coord(origin.y)
// write_coord(origin.z)
// write_coord(velocity.x)
// write_coord(velocity.y)
// write_coord(velocity.z)
// write_byte(life * 10)
// write_byte(color) this is an index into an array of color vectors in the engine. (0 - )
// write_byte(length * 10)
