/* AMX Mod X script.
*
* (c) Copyright 2005, skywalker
*
*  This plugin opens the amx mod x menu or amx modx client menu when you
*  say "menu" in normal chat.
*
*  This plugin opens the amx modx client menu when you
*  say "clmenu" in normal chat.
*
*  This plugin execute a client command when you
*  say "cmd <command line>" in normal chat.
*  
*/

#include <amxmodx>

public say_menu(id)
{
	if (get_user_flags(id) & ADMIN_MENU)
		client_cmd(id,"amxmodmenu")
	else
		client_cmd(id,"amx_menu")
	return PLUGIN_HANDLED
}

public say_clmenu(id)
{
	client_cmd(id,"amx_menu")
	return PLUGIN_HANDLED
}

public say_cmd(id)
{
	new cmdline[256]
	read_args(cmdline, 255)
	remove_quotes(cmdline)
	if (equal(cmdline,"cmd"))
	{
		console_print(id, "%L: say cmd <command line> - Execute command from client",id,"USAGE")
		return PLUGIN_HANDLED
	}
	if (contain(cmdline,"cmd ")==0)
	{
		trim(cmdline[4])
		if (cmdline[4])		
			client_cmd(id, cmdline[4])
		else
			console_print(id, "%L: say cmd <command line> - Execute command from client",id,"USAGE")
		return PLUGIN_HANDLED
	}
	return PLUGIN_CONTINUE
}

public plugin_init()
{
	register_plugin("Say menu","1.0","Rulzy")
	register_dictionary("common.txt")
	register_clcmd("say menu","say_menu",ADMIN_ALL,"- displays User menu")
	register_clcmd("say clmenu","say_clmenu",ADMIN_ALL,"- displays Amx Mod X Client Menu")
	register_clcmd("say","say_cmd",ADMIN_ALL,"cmd <command line> - Execute command from client")
	return PLUGIN_CONTINUE
}
