/* by BAILOPAN, Contributors: Asskicr, FreeCode, Ideas: isbunk
 *
 * csdm_mod.sma
 * Allows for Counter-Strike to be played as DeathMatch.

 * (C)2004 The TCW Organization and David "BAILOPAN" Anderson
 * Creation: 01-02-2004 Last Edit: 02-25-2004
 * At 2004.11.10 edit by nwb13
 * http://www.tcwonline.org/ - BAILOPAN
 *
 *  Give credit where due.
 *  Share the source - it sets you free
 *  http://www.opensource.org/
 *  http://www.gnu.org/
 *
 *  to find the copy of chinese at http://www.dt-club,net/
 */
 
//Tampering with the author and name lines will violate copyrights
new PLUGINNAME[] = "CSDM Mod"
new VERSION[] = "1.69.1"
new BUILD_VERSION[] = "276"
new AUTHORS[] = "BAILOPAN"

//TROGDOR the MEMORY LEAKER!
#pragma dynamic 262144

#include <amxmodx>
#include <amxmisc>
#include <engine>
#include <fun>

#define MAX_SPAWNS 41
#define MAX_ENTITIES 1200
#define MAX_ENTS 250
#define MAX_DROP 200
#define MAX_TASKS 500
#define MAXMENUPOS 34
#define MAX_RESTRICTS 30
#define MAX_HOSTAGES 30

#define PISTOL_AMMO 1
#define SHOTGUN_AMMO 2
#define SMG_AMMO 3
#define RIFLE_AMMO 4 
#define AWP_AMMO 5
#define PARA_AMMO 6 

//These variables are for spawn points.
new SPAWN[MAX_SPAWNS][3]		//For spawn points
new Float:SpnVec[MAX_SPAWNS][3]	//
new Float:SpnAng[MAX_SPAWNS][3]	//
new SpnTeam[MAX_SPAWNS]			//
new SPAWNS_ENABLED				//
new SPAWNS						//
//For the old spawn points...
new Float:OldSpawns[MAX_SPAWNS][3]
new OldSpawnIDs[MAX_SPAWNS]
new Float:OldSpawnVecs[MAX_SPAWNS][3]
new Float:OldSpawnAngs[MAX_SPAWNS][3]
new OLD_SPAWNS
//These variables _PROBABLY_ hold data!
new mapFile[48]					//
new EntList[MAX_ENTS][24]		//For entities
new EntVecs[MAX_ENTS][3]		//
new EntId[MAX_ENTS]				//
new EntCount					//
new EntFile[60]					//
new Origins[33][3]				//Track origins
new bool:Swep[33] = false		//Menus
new g_MenuPos[33] 				//
new g_LastWep[33][2]			//
new bool:g_getArmor[33]			//
new bool:g_getGrens[33]			//
new bool:ShowMenu[33] = true	//
new bool:isSpawning[33]			//Spawning
new bool:isRespawn[33]			//
new DropId[MAX_DROP]			//Track dropped weapons
new DropTask[MAX_DROP]			//Track dropped weapon remove tasks
new Tasks[MAX_TASKS]			//Track tasks
new PackId[MAX_DROP]			//drop_pack tempents
new PackAmmo[MAX_DROP][6]		//0=pistol, 1=shotgun, 2=smg, 3=rifle, 4=awp, 5=para
new PackGren[MAX_DROP][3]		//0=fb, 1=sg, 2=he
new PackTask[MAX_DROP]			//pack tfasks
new EdictSlot[MAX_ENTITIES]		//Entities
new BlockedWps[MAX_RESTRICTS]
new RestrictWps[MAX_RESTRICTS]	//
new Float:HostageVecs[MAX_HOSTAGES][3]
new HostageEnts[MAX_HOSTAGES]
new hostages
new Blocks
new bool:PackJump[MAX_DROP]		//pack longjumps
new Entities					//entities
new bool:HasLongJump[33] = false
new g_Aliases[MAXMENUPOS][] = {"usp","glock","deagle","p228","elites","fn57","m3","xm1014","mp5","tmp","p90","mac10","ump45","ak47","galil","famas","sg552","m4a1","aug","scout","awp","g3sg1","sg550","m249","vest","vesthelm","flash","hegren","sgren","defuser","nvgs","shield","primammo","secammo"} 
new g_Aliases2[MAXMENUPOS][] = {"km45","9x19mm","nighthawk","228compact","elites","fiveseven","12gauge","autoshotgun","smg","mp","c90","mac10","ump45","cv47","defender","clarion","krieg552","m4a1","bullpup","scout","magnum","d3au1","krieg550","m249","vest","vesthelm","flash","hegren","sgren","defuser","nvgs","shield","primammo","secammo"}
new CurMaxEnt
new bool:Voting
new bool:CancelVote
new Votes
new Float:lastVote
//1=enable/disable 3=norm/freeforall 2=items/!items
new VoteFor

public plugin_init()
{
	register_plugin(PLUGINNAME, VERSION, AUTHORS)

	register_cvar("csdm_active", "1")			//Enable CSDM?
	register_cvar("csdm_freeze_time", "5")		//Spawn protection time
	register_cvar("csdm_add_items", "0")		//0=Players choose weapons, 1=Players find weapons
	register_cvar("csdm_item_time", "20.0")		//Time until items respawn
	register_cvar("csdm_random_spawns", "1")	//Use random spawns or regular spawns?
	register_cvar("csdm_kill_all", "0")			//0=Use normal teams 1=Free for all
	register_cvar("csdm_drop_packs", "0")		//0=Drop packs on death 1=Drop weapons on death
	register_cvar("csdm_allow_clguns", "0")		//Allows players to choose gun setups with "guns" command
	register_cvar("csdm_drop_weapons", "1")		//allow players to drop weapons?
	register_cvar("csdm_hold_many", "0")		//Allows players to hold more than one of each type.
	register_cvar("csdm_delete_time", "20.0")		//
	register_cvar("csdm_auto_equip", "0")		//Automatically equip players with armor
	register_cvar("csdm_auto_gren", "0")		//Automatically equip players with grenades
	register_cvar("csdm_spawn_spam", "0")		//gives respawning users a message
	register_cvar("csdm_enable_amenu", "1")		//Enables armor menu
	register_cvar("csdm_enable_gmenu", "1")		//Enables grenade menu
	register_cvar("csdm_spawn_protect", "1")	//Sets CSDM spawn mode
												//0=none
												//1=normal, stops when you move
												//2=high, stops after csdm_freeze_time
	register_cvar("csdm_battery", "20")			//Battery health
	register_cvar("csdm_medkit", "20")			//Medkit health
	register_cvar("csdm_explain", "1")			//Explain some usage, like longjump
	register_cvar("csdm_auto_drop", "1")		//Auto-drop guns
	register_cvar("csdm_pack_jumps", "1")		//Sets whether to pack jumps into drop packs.
	register_cvar("csdm_asskicr", "0")			//Use asskicr's changes:
													//AWP has separate ammo
													//Para has separate ammo
													//New ammo box type
	register_cvar("csdm_allow_radio", "1")		//radio?
	register_cvar("csdm_voting", "2")			//1=public 2=admin_level_a 0=disabled
	register_cvar("csdm_voteflags", "abc")		//a=csdm mod on/off c=norm/freeforall b=items or not
	register_cvar("csdm_ratio", "0.6")			//vote ratio
	register_cvar("csdm_votetime", "45")		//vote length
	register_cvar("csdm_nextvote", "180")		//vote wait time
	
	register_cvar("csdm_steam", "1")			//Sets for steam or not.
	register_cvar("csdm_sounds", "1")			//Use sounds?
   
	register_menucmd(register_menuid("CSDM: 装备选择菜单"),1023,"EquipChoice")
	register_menucmd(register_menuid("CSDM: 选择主要武器"),1023,"PrimaryWeapon")
	register_menucmd(register_menuid("CSDM: 选择辅助武器"),1023,"SecondWeapon")
	register_menucmd(register_menuid("CSDM: 防弹衣"),1023,"ArmorChoice")
	register_menucmd(register_menuid("CSDM: 辅助装备"),1023,"GrenChoice")
	register_menucmd(register_menuid("CSDM: 死亡竞赛开关"), (1<<0)|(1<<1), "vote_count")
	register_menucmd(register_menuid("CSDM: 模式选择"), (1<<0)|(1<<1), "vote_count")
	register_menucmd(register_menuid("CSDM: 自由竞赛开关"), (1<<0)|(1<<1), "vote_count")

	register_concmd("csdm_enable", "csdm_onoff", ADMIN_LEVEL_C, "Turn CSDM on or off.")
	register_concmd("csdm_items", "csdm_items", ADMIN_LEVEL_C, "Use items or not.")
	register_concmd("csdm_version", "csdm_version", 0, "Show CSDM Version.")
	register_concmd("csdm_setspawn", "csdm_setspawn", ADMIN_LEVEL_D, "Create a CSDM spawn point.")
	register_concmd("csdm_setspawnv", "csdm_setspawnv", ADMIN_LEVEL_D, "Create a CSDM spawn point with angle.")
	register_concmd("csdm_delspawn", "csdm_delspawn", ADMIN_LEVEL_D, "Delete a CSDM spawn point.")
	register_concmd("csdm_setent", "csdm_setent", ADMIN_LEVEL_D, "Add a CSDM entity.")
	register_concmd("csdm_delent", "csdm_delent", ADMIN_LEVEL_D, "Delete a CSDM entity.")
	register_concmd("csdm_ent", "csdm_ent", ADMIN_LEVEL_D, "Find the nearest entity.")
	register_concmd("csdm_spawncount", "csdm_spawncount", ADMIN_LEVEL_D, "See how many spawns there are.")
	register_concmd("csdm_viewspawns", "csdm_viewspawns", ADMIN_LEVEL_D, "View all spawns.")
	register_concmd("csdm_hidespawns", "csdm_hidespawns", ADMIN_LEVEL_D, "Hide all spawns.")
	register_concmd("csdm_rement", "csdm_rement", ADMIN_LEVEL_D, "Delete an entity.")
	register_concmd("csdm_origin", "csdm_origin", 0, "Find your origin for debugging bad spawns.")
	register_concmd("csdm_near", "csdm_near", ADMIN_LEVEL_D, "Shows you the number of the nearest spawn point.")
	register_concmd("csdm_set_amenu", "csdm_set_amenu", ADMIN_LEVEL_B, "Turns armor menus off/on.")
	register_concmd("csdm_set_gmenu", "csdm_set_gmenu", ADMIN_LEVEL_B, "Turns grenade menus off/on.")
	register_concmd("csdm_killall", "csdm_killall", ADMIN_LEVEL_B, "Turns kill everyone mode off/on.")
	register_concmd("csdm_look", "csdm_look", ADMIN_LEVEL_D, "Returns the entity id you are looking at.")
	register_concmd("csdm_spawninfo", "csdm_spawninfo", ADMIN_LEVEL_A, "Returns the classname of an entity id.")
	register_concmd("csdm_entinfo", "csdm_entinfo", ADMIN_LEVEL_A, "Returns the classname of an entity id.")
	register_concmd("csdm_cancelvote", "cancel_vote", ADMIN_LEVEL_A, "Cancels a CSDM vote in session.")
	register_concmd("csdm_vote", "csdm_vote", 0, "Vote for CSDM.")
	register_concmd("vote_csdm", "csdm_vote", 0, "Vote for CSDM.")
	register_concmd("vote_mode", "vote_mode", 0, "Vote for CSDM Mode.")
	register_concmd("vote_freeforall", "vote_freeforall", 0, "Vote for Free-For-All mode.")
	register_concmd("csdm_entdump", "csdm_entdump", ADMIN_LEVEL_D, "Dumps a text file with entity information.")
	register_concmd("csdm_entcount", "csdm_entcount", ADMIN_LEVEL_D, "Returns the number of entities in the map.")

	register_clcmd("drop", "hook_drop")
	register_clcmd("respawn", "hook_respawn")
	register_clcmd("guns", "hook_guns")
	register_clcmd("give", "hook_give")
	register_clcmd("enable_menu", "hook_menu")
	register_clcmd("say guns", "hook_guns")
	register_clcmd("say respawn", "hook_respawn")
	register_clcmd("say menu", "hook_menu")
	register_clcmd("say enablemenu", "hook_menu")
	register_clcmd("say enable_menu", "hook_menu")
	// from AssKicr
	register_clcmd("buy", "hook_block")
	register_clcmd("buyammo1", "hook_block")
	register_clcmd("buyammo2", "hook_block")
	register_clcmd("buyequip", "hook_block")
	register_clcmd("radio1", "hook_block_radio")
	register_clcmd("radio2", "hook_block_radio")
	register_clcmd("radio3", "hook_block_radio")
	register_clcmd("nightvision", "hook_block")
	register_clcmd("cl_setautobuy","hook_block") 
	register_clcmd("cl_autobuy","hook_block") 
	register_clcmd("cl_setrebuy","hook_block") 
	register_clcmd("cl_rebuy","hook_block")
	register_clcmd("say csdm_vote", "csdm_votesay")
	register_clcmd("say vote_csdm", "csdm_votesay")
	register_clcmd("say vote_mode", "vote_modesay")
	register_clcmd("say vote mode", "vote_modesay")
	register_clcmd("say vote_freeforall", "vote_freeforallsay")
	register_clcmd("say vote freeforall", "vote_freeforallsay")
	//
	register_event("ResetHUD","hook_hud","be")
	register_event("DeathMsg", "hook_death", "a")
   	//from dm autopilot, which took from jailbreak
	register_menucmd(register_menuid("Terrorist_Select"), 1023, "hook_skin")
	register_menucmd(register_menuid("CT_Select"), 1023, "hook_skin")
	register_menucmd(-26,1023, "hook_skin")      // VGUI
	register_menucmd(-27,1023, "hook_skin")      // VGUI
	register_event("ShowMenu", "hook_team", "b", "4&Team_Select")
	register_event("VGUIMenu", "hook_team", "b", "1=2")
	register_event("CurWeapon","hook_changeweapon","be","1=1","2=6")

	set_task(0.5, "start_map")
	set_task(10.0, "check_players", 1210, "", 0, "b")
	
	//oink.
	register_logevent("hook_roundstart", 2, "0=World triggered", "1=Round_Start")
	
	return PLUGIN_CONTINUE
}

public plugin_precache()
{
	precache_model("models/w_medkit.mdl")
	precache_model("models/w_battery.mdl")
	precache_model("models/w_357ammobox.mdl")	//Pistol Ammo
	precache_model("models/w_shotbox.mdl")		//Shotgun Ammo
	precache_model("models/w_9mmclip.mdl")		//SMG Ammo
	precache_model("models/w_9mmarclip.mdl")	//Rifle Ammo
	precache_model("models/w_crossbow_clip.mdl")//Awp Ammo
	precache_model("models/w_isotopebox.mdl")	//Full ammo
	precache_model("models/w_isotopeboxt.mdl")	//Full ammo
	precache_model("models/w_chainammo.mdl")	//Full ammo
	precache_model("models/w_suit.mdl")			//Suit
	precache_model("models/w_suitt.mdl")		//
	precache_model("models/w_weaponbox.mdl")	//Drop pack
	precache_model("models/w_assault.mdl")		//assaultsuit
	precache_model("models/w_longjump.mdl")		//longjump - thanks asskicr
	precache_model("models/w_longjumpt.mdl")	//"
	precache_model("models/gman.mdl")
	precache_model("models/gmant.mdl")
	precache_sound("items/smallmedkit1.wav")
	precache_sound("items/gunpickup2.wav")
	precache_sound("items/suitchargeok1.wav")
	precache_sound("items/ammopickup2.wav")
	precache_sound("items/clipinsert1.wav")
	precache_sound("debris/metal3.wav")
	
	return PLUGIN_CONTINUE
}

public csdm_near(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	new marker, dist=9999, cur
	new PVec[3]
	new i
	
	marker = -1
	get_user_origin(id, PVec)
	for (i=0; i<SPAWNS; i++) {
		cur = get_distance(PVec, SPAWN[i])
		if (cur < dist) {
			dist = cur
			marker = i
		}
	}
	
	if (marker != -1) {
		client_print(id, print_console, "[CSDM] The nearest spawn to you is number %d", marker+1)
	} else {
		client_print(id, print_console, "[CSDM] No spawns found.")
	}
	
	return PLUGIN_HANDLED
}

public check_players()
{
	new players[32], mPlayers
	new i
	if (get_cvar_num("csdm_active")) {
		get_players(players, mPlayers)
		for (i=0; i<mPlayers; i++) {
			if (!is_user_alive(players[i]) && ((get_user_team(players[i])==1) || (get_user_team(players[i])==2))) {
				//oops!
				new Data[2]
				Data[0] = players[i]
				set_task(0.5, "quick_respawn", 0, Data, 2)
				isRespawn[players[i]] = true
			}
		}
	}
	
	return PLUGIN_CONTINUE
}

public hook_changeweapon(id)
{
	new data[3]
	if (get_cvar_num("csdm_active")) {	
		//houston, we have a c4.
		if (!is_user_bot(id)) {
			client_cmd(id, "drop weapon_c4")
		} else {
			client_cmd(id, "drop weapon_c4")
		}
		data[0] = CSW_C4
		data[1] = 0
		data[2] = id
		set_task(0.2, "timed_replace", 0, data, 3)
	}
	
	return PLUGIN_CONTINUE
}

public hook_roundstart()
{
	set_task(1.0, "timed_roundstart")
}

public timed_roundstart(data[])
{
	destroyHostages()
}

destroyHostages()
{
	//look for hostages - and DESTROY THEM!
	/// HA, HA HA HA HA HA HA HA HA AH!

	if (get_cvar_num("csdm_active")) {
		new tEnt = find_ent_by_class(-1, "hostage_entity")
		new tfEnt
		while (tEnt > 0) {
			tfEnt = find_ent_by_class(tEnt, "hostage_entity")
			if (hostages == MAX_HOSTAGES) {
				hostages = 0
			} else {
				hostages++
			}
			entity_get_vector(tEnt, EV_VEC_origin, HostageVecs[hostages])
			HostageEnts[hostages] = tEnt
			hideEnt(tEnt)	//Make it so Dan can't grope them.
			tEnt = tfEnt
		}
	}
}

restoreHostages()
{
	new i
	for (i=1; i<=hostages; i++) {
		entity_set_int(HostageEnts[i], EV_INT_rendermode, kRenderNormal)
		entity_set_origin(HostageEnts[i], HostageVecs[i])
	}
	hostages = 0
}

hideEnt(ent)
{
	new Float:Vec[3] = {10000.0,10000.0,10000.0}
	entity_set_int(ent, EV_INT_rendermode, kRenderTransTexture)
	entity_set_origin(ent, Vec)
}

public client_connect(id)
{
	ShowMenu[id] = true
	isSpawning[id] = true
	g_LastWep[id][0] = 0
	g_LastWep[id][1] = 0
	g_getArmor[id] = false
	g_getGrens[id] = false
	isRespawn[id] = true
	HasLongJump[id] = false
	
	return PLUGIN_CONTINUE
}

public client_putinserver(id)
{
	new data[2]
	
	if (get_cvar_num("csdm_active")) {
		data[0] = id
		set_task(10.0, "introduce", 0, data, 2)
	}
	
	return PLUGIN_CONTINUE
}

public client_command(id){ 	//from AssKicr
	if (get_cvar_num("csdm_active") && is_user_alive(id)) {
		new arg[13]
		if (read_argv(0, arg, 12) > 11)
			return PLUGIN_CONTINUE 
		new a = 0 
		do {
			if (equal(g_Aliases[a], arg) || equal(g_Aliases2[a], arg)) { 
				return PLUGIN_HANDLED 
			}
		} while(++a < MAXMENUPOS)
	}
	
	return PLUGIN_CONTINUE 
} 

public introduce(data[])
{
	new id = data[0]
	
	if (get_cvar_num("csdm_active")) {
	
		client_print(id, print_chat, "[CSDM] 欢迎来到本服务器, 服务器使用了死亡竞赛插件.")	
		client_print(id, print_chat, "[CSDM] 更多信息请浏览 www.lambdacore.net 或者 www.dt-club.net")
		client_print(id, print_chat, "[CSDM] 手动输入命令: ^"respawn^" 可以获得重生.")
		if (get_cvar_num("csdm_allow_clguns")) {
			client_print(id, print_chat, "[CSDM] 输入命令 ^"guns^" 开启选枪菜单, ^"give 武器名^" 得到指定的武器.")
		}
	}

	return PLUGIN_CONTINUE
}

public plugin_end()
{
	destroyAllItems()
	
	return PLUGIN_CONTINUE
}

destroyAllItems()
{	
	new i
	
	//kill all ents
	for (i=1; i<EntCount; i++) {
		if (EntId[i] > 32) {
			if (is_valid_ent(EntId[i])) {
				safe_rm_ent(EntId[i])
			}
			EntId[i] = 0
		}
	}

	for (i=1; i<MAX_DROP; i++) {
		destroyPack(i)
	}
	
	for (i=1; i<MAX_ENTITIES; i++) {
		if (EdictSlot[i] && is_valid_ent(EdictSlot[i])) {
			safe_rm_ent(EdictSlot[i])
		}
	}
}

public start_map()
{	
	if (get_cvar_num("csdm_active")) {
		checkMod()
		readMapFile()
		readWeaponsFile()
		setSpawns()
		readEntsFile()
		setEnts()
		destroyHostages()
		server_cmd("sv_restartround 2")
	}
}


public csdm_killall(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_B)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	if (get_cvar_num("csdm_kill_all")) {
		client_print(id, print_console, "[CSDM] Free for all mode is now disabled.")
		set_cvar_num("csdm_kill_all", 0)
		checkMod()
		return PLUGIN_HANDLED
	} else {
		client_print(id, print_console, "[CSDM] Free for all mode is now enabled.")
		set_cvar_num("csdm_kill_all", 1)
		set_cvar_num("mp_autokick", 0)
		set_cvar_num("mp_tkpunish", 0)
		set_cvar_num("mp_autoteambalance", 0)
		set_cvar_num("mp_friendlyfire", 1)
		return PLUGIN_HANDLED
	}
	
	return PLUGIN_HANDLED
}

public csdm_set_amenu(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_B)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	if (get_cvar_num("csdm_enable_amenu")) {
		client_print(id, print_console, "[CSDM] Armor menu is now disabled.")
		set_cvar_num("csdm_enable_amenu", 0)
		return PLUGIN_HANDLED
	} else {
		client_print(id, print_console, "[CSDM] Armor menu is now enabled.")
		set_cvar_num("csdm_enable_amenu", 1)
		return PLUGIN_HANDLED
	}
	
	return PLUGIN_HANDLED
}

public csdm_set_gmenu(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_B)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	if (get_cvar_num("csdm_enable_gmenu")) {
		client_print(id, print_console, "[CSDM] Grenade menu is now disabled.")
		set_cvar_num("csdm_enable_gmenu", 0)
		return PLUGIN_HANDLED
	} else {
		client_print(id, print_console, "[CSDM] Grenade menu is now enabled.")
		set_cvar_num("csdm_enable_gmenu", 1)
		return PLUGIN_HANDLED
	}
	
	return PLUGIN_HANDLED
}

public hook_team(id)
{
	if (get_cvar_num("csdm_active")) {
		new tID[2]
		tID[0] = id
		set_task(6.0, "quick_respawn", 0, tID, 2)
	}
	
	return PLUGIN_CONTINUE
}

public hook_skin(id)		//from dm autopilot
{
	if (!get_cvar_num("csdm_active")) {
		return PLUGIN_CONTINUE
	}
	
	new parm[2]
	parm[0]=id
	set_task(6.0, "wait_alive", 1037, parm, 2)
	
	return PLUGIN_CONTINUE
}

public wait_alive(parm[])	//from dm autopilot
{	
	new id = parm[0]
	if (!is_user_alive(id) && ((get_user_team(id)==1) || (get_user_team(id)==2))) {
		new svIndex[2]
		svIndex[0] = id
		set_task(0.5, "quick_respawn", 0, svIndex, 2)
	}
	return PLUGIN_CONTINUE
}

public csdm_origin(id)
{
	new Vec[3]
	
	get_user_origin(id, Vec)
	client_print(id, print_console, "[CSDM] Your origin is (%d, %d, %d).", Vec[0], Vec[1], Vec[2])
	
	return PLUGIN_HANDLED
}

public hook_block_radio(id)
{
	if (get_cvar_num("csdm_active") && !get_cvar_num("csdm_allow_radio")) {
		return PLUGIN_HANDLED
	}
	
	return PLUGIN_CONTINUE
}

public hook_block(id)
{
	if (get_cvar_num("csdm_active")) {
		return PLUGIN_HANDLED
	}
	
	return PLUGIN_CONTINUE
}

public hook_menu(id)
{
	if (!get_cvar_num("csdm_active")) {
		return PLUGIN_HANDLED
	}
	if (ShowMenu[id]) {
		ShowMenu[id] = false
		client_print(id, print_console, "[CSDM] Weapons menu is now off.")
		if (get_cvar_num("csdm_allow_clguns")) {
			client_print(id, print_console, "[CSDM] You can use ^"guns^" and ^"give <gun>^" to get weapons.")
		}
		return PLUGIN_HANDLED
	} else {
		ShowMenu[id] = true
		client_print(id, print_console, "[CSDM] Weapons menu is now on.")
		if (get_cvar_num("csdm_allow_clguns")) {
			client_print(id, print_console, "[CSDM] You can use ^"guns^" and ^"give <gun>^" to get weapons.")
		}
		return PLUGIN_HANDLED
	}
	
	return PLUGIN_HANDLED
}

public hook_respawn(id)
{
	if (!get_cvar_num("csdm_active")) {
		return PLUGIN_HANDLED
	}
	if (!is_user_alive(id) && id) {
		new Data[2]
		Data[0] = id
		respawn(Data)
	}
	
	return PLUGIN_HANDLED
}

public hook_give(id)
{
	if (!get_cvar_num("csdm_active")) {
		return PLUGIN_HANDLED
	}
	if (get_cvar_num("csdm_allow_clguns") && !get_cvar_num("csdm_add_items")) {
		new data[16], wpn[24], wp
		read_argv(1, data, 16)
		format(wpn, 24, "weapon_%s", data)
		wp = getWepId(wpn)
		if (!wp) {
			client_print(id, print_console, "[CSDM] Invalid gun!")
			
			return PLUGIN_HANDLED
		} else {
			if (get_cvar_num("csdm_hold_many")) {
				giveGun(id, wp, 2)
			} else {
				if (canGetGun(id, wp)) {
					giveGun(id, wp, 2)
				} else {
					client_print(id, print_console, "[CSDM] Sorry, you can't hold this weapon.")
					
					return PLUGIN_HANDLED
				}
			}
		}
	} else {
		client_print(id, print_console, "[CSDM] Client gun commands are disabled.")
	}
	
	return PLUGIN_HANDLED
}

public hook_guns(id)
{
	if (!get_cvar_num("csdm_active")) {
		return PLUGIN_HANDLED
	}
	if (get_cvar_num("csdm_allow_clguns") && !get_cvar_num("csdm_add_items")) {
		if (is_user_alive(id)) {
			EquipMenu(id)
		}
	} else {
		client_print(id, print_chat, "[CSDM] 抱歉, 客户端选枪菜单被禁止使用.")
	}
	
	return PLUGIN_HANDLED
}


public hook_drop(id)
{
	if (get_cvar_num("csdm_active")) {
		new wp, c, a, Drop[3]
		
		wp = get_user_weapon(id, c, a)
		Drop[0] = wp
		if (get_cvar_num("csdm_drop_weapons")) {
			Drop[1] = 0
		} else {
			Drop[1] = 1
		}
		Drop[2] = id
				
		set_task(0.2, "timed_replace", 0, Drop, 3)
	}
	
	return PLUGIN_CONTINUE
}

force_drop_all(id)
{
	new drop[3], authid[20]
	
	get_user_authid(id, authid, 20)
	
	if (is_user_alive(id)) {
		if (get_user_team(id) == 1) {
			if (equali(authid, "BOT")) { 
				client_cmd(id, "drop")
			} else {
				client_cmd(id, "drop %s", "weapon_glock18")
			}
			drop[0] = CSW_GLOCK18
			drop[1] = 1
			drop[2] = id
			set_task(0.2, "timed_replace", 0, drop, 3)
		} else if (get_user_team(id) == 2) {
			if (equali(authid, "BOT")) { 
				client_cmd(id, "drop")
			} else {
				client_cmd(id, "drop %s", "weapon_usp")
			}
			drop[0] = CSW_USP
			drop[1] = 1
			drop[2] = id
			set_task(0.2, "timed_replace", 0, drop, 3)
		}
	}
}

public csdm_rement(id, level, cid)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	new S[4]
	new s
	
	read_argv(1, S, 4)
	s = str_to_num(S)
	
	client_print(id, print_console, "Removing entity #%d", s)
	remove_entity(s)
	
	return PLUGIN_HANDLED
}

public timed_rem_drop(data[])
{
	new id = data[0]
	
	destroyDrop(id)
	
	return PLUGIN_CONTINUE	
}

public timed_replace(data[])
{
	new wp = data[0]
	new hide = data[1]
	new p = data[2]
	
	if (!hide) {
		replaceWeapons(wp, 0, p)
	} else {
		replaceWeapons(wp, 1, p)
	}
	
	return PLUGIN_CONTINUE
}

replaceWeapons(wp, hide=0, p)
{
	new model[32], wmodel[32]
	new Float:RVec[3], Float:AVec[3]
	new entid
	new Float:Vel[3]
	new oid, tEnt, tfEnt
	new x = 0
	
	getWepModel(wp, model, 32)
	
	if (wp && strlen(model) && isValidDrop(wp)) {
		tEnt = find_ent_by_class(-1, "weaponbox")
		while (tEnt > 0) {
			tfEnt = find_ent_by_class(tEnt, "weaponbox")
			entity_get_string(tEnt, EV_SZ_model, wmodel, 32)
			if (equali(model, wmodel)) {
				oid = entity_get_edict(tEnt, EV_ENT_owner)
				if (oid == p) {
					//Do not recreate C4.
					if (wp != CSW_C4) {
						entity_get_vector(tEnt, EV_VEC_origin, RVec)
						if (get_cvar_num("csdm_drop_weapons") && !hide && !isWpBlocked(wp)) {
							entity_get_vector(tEnt, EV_VEC_angles, AVec)
							entity_get_vector(tEnt, EV_VEC_velocity, Vel)
							entid = makeWeapon(wp, RVec, AVec, Vel)
							if (entid) {
								createDrop(entid)
							}
						}
					}
					//this may or may not work.
					safe_rmweapon(wp, tEnt)
				} else {
					if (wp == CSW_C4) {
						safe_rmweapon(wp, tEnt)
					}
				}
			}
			tEnt = tfEnt
		}
	}
		
	return x	//number of ents removed
}

//Nine out of ten people agree that BAILOPAN is actually insane.
safe_rmweapon(wp, entid)
{
	new wEnt, wfEnt, name[24]
	new woEnt
	
	if (get_cvar_num("csdm_steam")) {
		if (wp != CSW_C4) {
			call_think(entid)		//This took so long to figure out, nations rose and fell while waiting.
		} else {
			hideEnt(entid)		//didn't have time to test if c4 thinks.
			return 0
		}
	} else {
		remove_entity(entid)
	}
	get_weaponname(wp, name, 24)
	wEnt = find_ent_by_class(-1, name)
	while (wEnt > 0) {
		wfEnt = find_ent_by_class(wEnt, name)
		woEnt = entity_get_edict(wEnt, EV_ENT_owner)
		if (isValidSubOwner(woEnt) && woEnt == entid) {
			if (get_cvar_num("csdm_steam")) {
				call_think(wEnt)
			} else {
				remove_entity(wEnt)
			}
		}
		wEnt = wfEnt
	}
	
	return 1
}

bool:isValidSubOwner(oid)
{
	if (oid > 32 && oid) {
		return true
	}
	
	return false
}

public hook_hud(id)
{
	new param[1]

	param[0] = id 
	set_task(0.1, "hook_hud_delayed", 3000+id, param, 1)
	
	return PLUGIN_CONTINUE
}

public hook_hud_delayed(param[])
{
	new id = param[0]
	
	if (get_cvar_num("csdm_active")) {
		if (!get_cvar_num("csdm_add_items")) {
			if (isRespawn[id]) {
				isRespawn[id] = false
				force_drop_all(id)
				set_task(0.4, "hook_hud_delayed", 3000+id, param, 2)
				
				return PLUGIN_CONTINUE
			}
			if (ShowMenu[id]) {
				EquipMenu(id)
				if (g_getArmor[id] || get_cvar_num("csdm_auto_equip")) {
					set_user_armor(id, 100)
					give_item(id, "item_assaultsuit")
				}
				if (g_getGrens[id] || get_cvar_num("csdm_auto_gren")) {
					giveGun(id, CSW_HEGRENADE, 2)
					giveGun(id, CSW_SMOKEGRENADE, 2)
					giveGun(id, CSW_FLASHBANG, 2)
					giveGun(id, CSW_FLASHBANG, 2)
				}
			} else {
				giveGun(id, g_LastWep[id][0], 1)
				giveGun(id, g_LastWep[id][1], 0)
				if (g_getArmor[id] || get_cvar_num("csdm_auto_equip")) {
					set_user_armor(id, 100)
					give_item(id, "item_assaultsuit")
				}
				if (g_getGrens[id] || get_cvar_num("csdm_auto_gren")) {
					giveGun(id, CSW_HEGRENADE, 2)
					giveGun(id, CSW_SMOKEGRENADE, 2)
					giveGun(id, CSW_FLASHBANG, 2)
					giveGun(id, CSW_FLASHBANG, 2)
				}
				if (get_cvar_num("csdm_spawn_span") && !get_cvar_num("csdm_allow_clguns")) {
					client_print(id, print_chat, "[CSDM] 你可以输入 ^"enable_menu^" 或者 ^"guns^" 重新开启选枪菜单.")
				}
			}
		}
		if (HasLongJump[id]) {
			give_item(id, "item_longjump")
		}
	}
	
	return PLUGIN_CONTINUE
}

public hook_death()
{
	new pk = read_data(1)
	new pv = read_data(2)
	new Vec[3]
	new svIndex[2], wps[32], Drop[3], num

	if (get_cvar_num("csdm_active")) {
		svIndex[0] = pv
		set_task(0.5, "quick_respawn", 0, svIndex, 2)
		isSpawning[pv] = true
		get_user_origin(pv, Vec)
		if (get_cvar_num("csdm_drop_packs") && get_cvar_num("csdm_add_items")) {
			createPack(pv, Vec)
		}
		if (get_cvar_num("csdm_kill_all")) {
			if (get_user_team(pk) == get_user_team(pv)) {
				set_user_frags(pk, get_user_frags(pk)+2)
			}
		}
		HasLongJump[pv] = false
		num = 0
		get_user_weapons(pv, wps, num)		//catch every dropped weapon!
		new i
		for (i=0; i<num; i++) {
			if (isValidDrop(wps[i])) {
				Drop[0] = wps[i]
				Drop[2] = pv
				if (get_cvar_num("csdm_drop_weapons")) {
					Drop[1] = 0
				} else {
					if (get_cvar_num("csdm_drop_packs") && get_cvar_num("csdm_add_items")) {
						Drop[1] = 1
					} else {
						Drop[1] = 0
					}
				}
				set_task(0.2, "timed_replace", 0, Drop, 3)
			}
		}
		isRespawn[pv] = true
	}
	
	return PLUGIN_CONTINUE
}

public quick_respawn(svIndex[])
{
	new vIndex = svIndex[0]
	if (!is_user_alive(vIndex) && ((get_user_team(vIndex)==1) || (get_user_team(vIndex)==2))) {
		spawn(vIndex)
		set_task(0.1, "respawn", 0, svIndex, 2)
	}	
	return PLUGIN_CONTINUE
}

public respawn(svIndex[])
{
	new vIndex = svIndex[0]
	
	if (get_user_team(vIndex)==3) {
		return PLUGIN_CONTINUE
	} else {
		if (get_user_team(vIndex) == 1 || get_user_team(vIndex) == 2) {
			spawn(vIndex)
			isSpawning[vIndex] = true
			new Float:Time = get_cvar_float("csdm_freeze_time")
			get_user_origin(vIndex, Origins[vIndex])
			set_task(Time, "unfreeze", 0, svIndex, 2)
			if (get_cvar_num("csdm_spawn_spam")) {
				client_print(vIndex, print_chat, "[CSDM] 你正在进行的游戏是反恐精英: 死亡竞赛")	
				client_print(vIndex, print_chat, "[CSDM] 手动输入命令: ^"respawn^" 可以获得重生.")
				if (get_cvar_num("csdm_allow_clguns")) {
					client_print(vIndex, print_chat, "[CSDM] 输入命令 ^"guns^" 开启选枪菜单, ^"give 武器名^" 得到指定的武器.")
				}
			}
			if (get_cvar_num("csdm_spawn_protect")>0) {
				set_user_health(vIndex, 10239)
				if (get_cvar_num("csdm_kill_all"))
					set_user_rendering(vIndex, kRenderFxGlowShell, 0, 255, 0, kRenderNormal, 30)
				else if (get_user_team(vIndex) == 1)
					set_user_rendering(vIndex, kRenderFxGlowShell, 255, 0, 0, kRenderNormal, 30)
				else if (get_user_team(vIndex) == 2)
					set_user_rendering(vIndex, kRenderFxGlowShell, 0, 0, 255, kRenderNormal, 30)
				if (get_cvar_num("csdm_spawn_protect")==1) {
					set_task(0.2, "check_move", 0, svIndex, 2, "a", floatround(Time/0.25))
				}
			}
		} else {
			return PLUGIN_CONTINUE
		}
	}
	
	return PLUGIN_CONTINUE
}

public check_move(svIndex[])
{
	new vIndex = svIndex[0]
	new Origin[3]
	
	if (isSpawning[vIndex]) {
	
		get_user_origin(vIndex, Origin)
		
		if ((Origins[vIndex][0] != Origin[0]) && is_user_connected(vIndex)) {
			unfreeze(svIndex)
		} else if ((Origins[vIndex][1] != Origin[1]) && is_user_connected(vIndex)) {
			unfreeze(svIndex)
		}
	}
	
	return PLUGIN_CONTINUE
}

public unfreeze(svIndex[])
{
	new vIndex = svIndex[0]

	if (get_cvar_num("csdm_spawn_protect")>0) {
		set_user_health(vIndex, 100)
		set_user_rendering(vIndex, kRenderFxNone, 0, 0, 0, kRenderNormal, 0)
	}
	if (get_cvar_num("csdm_add_items")) {
		if (get_cvar_num("csdm_auto_equip")) {
			give_item(vIndex, "item_assaultsuit")
			set_user_armor(vIndex, 100)
		}
		if (get_cvar_num("csdm_auto_gren")) {
			give_item(vIndex, "weapon_hegrenade")
			give_item(vIndex, "weapon_flashbang")
			give_item(vIndex, "weapon_flashbang")
			give_item(vIndex, "weapon_smokegrenade")
		}
	}

	isSpawning[vIndex] = false
	
	return PLUGIN_CONTINUE
}

public csdm_version(id)
{
	console_print(id, "[CSDM] Counter-Strike Deathmatch Version %s, build %s.", VERSION, BUILD_VERSION)
	console_print(id, "[CSDM] Made by BAILOPAN.")
	
	return PLUGIN_HANDLED
}

public csdm_entcount(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	console_print(id, "[CSDM] There are currently %d entities in the edict table.", entity_count())
	console_print(id, "[CSDM] There are currently %d defined entities in the map.", EntCount-1)
	
	return PLUGIN_HANDLED
}

public csdm_entdump(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	new S[4]
	new s
	
	read_argv(1, S, 4)
	s = str_to_num(S)
	
	new i
	new model[32]
	new owner
	new class[32]
	new Text[128]
	new entid, pid, did
	log_to_file("csdm-ents.txt", "[CSDM] Entity dump output.")
	for (i=s; i<=entity_count(); i++) {
		if (is_valid_ent(i)) {
			entity_get_string(i, EV_SZ_classname, class, 32)
			entity_get_string(i, EV_SZ_model, model, 32)
			entid = findEntId(i)
			pid = findPackId(i)
			did = findDrop(i)
			owner = entity_get_edict(i, EV_ENT_owner)
			format(Text, 128, "[%d] (%d,%d,%d,%d) ^"%s^" ^"%s^"", i, owner, entid, pid, did, class, model)
			write_file("addons\amxmodx\logs\csdm-ents.txt", Text, -1)
		}
	}
	
	return PLUGIN_HANDLED
}

public csdm_entinfo(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_A)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	new ptrClass[32]
	new S[4]
	new s
	
	read_argv(1, S, 4)
	s = str_to_num(S)
	
	if (s>EntCount || s<1) {
		client_print(id, print_console, "[CSDM] That entity was not found.")
		
		return PLUGIN_HANDLED
	}
	
	if (EntId[s]) {
		entity_get_string(EntId[s], EV_SZ_classname, ptrClass, 32)
	
		client_print(id, print_console, "[CSDM] Entity (%d) has classname ^"%s^".", s, ptrClass)
	} else {
		client_print(id, print_console, "[CSDM] Entity (%d) is not currently spawned.", s)
	}
	
	return PLUGIN_HANDLED
}

public csdm_spawninfo(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_A)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	new S[4]
	new s
	
	read_argv(1, S, 4)
	s = str_to_num(S)
	
	if (s>0 && s<=SPAWNS) {
		console_print(id, "[CSDM] Spawn %d has defs (%d %d %d) [%d %d %d]", s, SPAWN[s][0], SPAWN[s][1], SPAWN[s][2], floatround(SpnVec[s][0]), floatround(SpnVec[s][1]), floatround(SpnVec[s][2]))
	}
	
	return PLUGIN_HANDLED
}

public csdm_look(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		return PLUGIN_HANDLED
	}
	
	new marker, dist=100, cur, PVec[3]
	new i
	
	marker = -1
	get_user_origin( id, PVec, 3)

	for (i=1; i<EntCount; i++) {
		cur = get_distance(PVec, EntVecs[i])
		if (cur < dist) {
			dist = cur
			marker = i
		}
	}

	if (marker!=-1) {
		client_print(id, print_console, "[CSDM] CSDM Entity found: id=%d distance=%d entid=%d", marker, dist, EntId[marker])
	}else{
		client_print(id, print_console, "[CSDM] No Entity found.")
	}

	return PLUGIN_HANDLED
}

public csdm_ent(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		return PLUGIN_HANDLED
	}
		
	new marker, dist=9999, cur
	new PVec[3]
	new i
	
	marker = -1
	get_user_origin(id, PVec)

	for (i=1; i<EntCount; i++) {
		cur = get_distance(PVec, EntVecs[i])
		if (cur < dist) {
			dist = cur
			marker = i
		}
	}
	
	if (marker != -1) {
		client_print(id, print_console, "[CSDM] The nearest entity to you is number %d", marker)
	} else {
		client_print(id, print_console, "[CSDM] No entities found.")
	}
		
	return PLUGIN_HANDLED
}

public csdm_delent(id, level, cid)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	new Text[64]
	new S[4]
	new s
	new i
	
	read_argv(1, S, 4)
	s = str_to_num(S)
	
	if (s>EntCount || s<1) {
		client_print(id, print_console, "[CSDM] That entity was not found.")
		
		return PLUGIN_HANDLED
	}
	
	new entid = EntId[s]
	
	rment(entid)
	
	if (s == EntCount-1) {
		EntList[s][0] = 0
		EntVecs[s][0] = 0
		EntVecs[s][1] = 0
		EntVecs[s][2] = 0
		EntId[s] = 0
	} else if (s == EntCount-2) {
		copy(EntList[s], 24, EntList[s+1])
		EntVecs[s][0] = EntVecs[s+1][0]
		EntVecs[s][1] = EntVecs[s+1][1]
		EntVecs[s][2] = EntVecs[s+1][2]
		EntId[s] = EntId[s+1]
	} else if (s < EntCount - 2) {
		for (i=s; i<EntCount-1; i++) {
			copy(EntList[i], 24, EntList[i+1])
			EntVecs[i][0] = EntVecs[i+1][0]
			EntVecs[i][1] = EntVecs[i+1][1]
			EntVecs[i][2] = EntVecs[i+1][2]
			EntId[i] = EntId[i+1]
		}
	}
	EntCount--
	delete_file(EntFile)
	for (i=1; i<EntCount; i++) {
		format(Text, 64, "%s %d %d %d", EntList[i], EntVecs[i][0], EntVecs[i][1], EntVecs[i][2])
		write_file(EntFile, Text, -1)
	}
	
	client_print(id, print_console, "[CSDM] Entity %d removed.", s)
	client_print(id, print_console, "[CSDM] There are now %d entities defined.", EntCount)
	
	return PLUGIN_HANDLED
}

public csdm_delspawn(id, level, cid)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	new Text[64]
	new S[4]
	new s
	new i
	
	read_argv(1, S, 4)
	s = str_to_num(S)
	
	if (s>SPAWNS) {
		client_print(id, print_console, "[CSDM] That spawn point was not found.")
		
		return PLUGIN_HANDLED
	}
	
	for (i=s; i<SPAWNS; i++) {
		SPAWN[i][0] = SPAWN[i+1][0]
		SPAWN[i][1] = SPAWN[i+1][1]
		SPAWN[i][2] = SPAWN[i+1][2]
		SpnVec[i][0] = SpnVec[i+1][0]
		SpnVec[i][1] = SpnVec[i+1][1]
		SpnVec[i][2] = SpnVec[i+1][2]
		SpnAng[i][0] = SpnAng[i+1][0]
		SpnAng[i][1] = SpnAng[i+1][1]
		SpnAng[i][2] = SpnAng[i+1][2]
		SpnTeam[i] = SpnTeam[i+1]
	}
	
	SPAWNS--
	delete_file(mapFile)
	for (i=1; i<=SPAWNS; i++) {
		format(Text, 64, "%d %d %d %d %d %d %d %d %d %d", SPAWN[i][0], SPAWN[i][1], SPAWN[i][2], floatround(SpnVec[i][0]), floatround(SpnVec[i][1]), floatround(SpnVec[i][2]), SpnTeam[i], floatround(SpnAng[i][0]), floatround(SpnAng[i][1]), floatround(SpnAng[i][2]))
		write_file(mapFile, Text, -1)
	}
	readMapFile()
	setSpawns()
	
	client_print(id, print_console, "[CSDM] Spawn point %d removed.", s)
	client_print(id, print_console, "[CSDM] There are now %d spawns defined.", SPAWNS)
	
	return PLUGIN_HANDLED
}

public csdm_setspawnv(id, level, cid)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	new IDVec[3]
	new Text[64]
	new Float:vAngle[3]
	new Float:oAngle[3]
	new team[4]
	new iTeam
	
	read_argv(1, team, 4)
	iTeam = str_to_num(team)
	
	if (SPAWNS == 0 || !SPAWNS_ENABLED) {
		SPAWNS_ENABLED = 1
	}
	if (SPAWNS == MAX_SPAWNS) {
		client_print(id, print_console, "[CSDM] Spawn limit reached at %d.", MAX_SPAWNS)
		
		return PLUGIN_HANDLED
	}
	
	get_user_origin(id, IDVec)
	entity_get_vector(id, EV_VEC_v_angle, vAngle)
	entity_get_vector(id, EV_VEC_angles, oAngle)
	IDVec[2] += 15
	format(Text, 64, "%d %d %d %d %d %d %d %d %d %d", IDVec[0], IDVec[1], IDVec[2], floatround(vAngle[0]), floatround(vAngle[1]), floatround(vAngle[2]), iTeam, floatround(oAngle[0]), floatround(oAngle[1]), floatround(oAngle[2]))
	write_file(mapFile, Text, -1)
	SPAWNS++
	SPAWN[SPAWNS][0] = IDVec[0]
	SPAWN[SPAWNS][1] = IDVec[1]
	SPAWN[SPAWNS][2] = IDVec[2]
	SpnVec[SPAWNS][0] = vAngle[0]
	SpnVec[SPAWNS][1] = vAngle[1]
	SpnVec[SPAWNS][2] = vAngle[2]
	SpnAng[SPAWNS][0] = oAngle[0]
	SpnAng[SPAWNS][1] = oAngle[1]
	SpnAng[SPAWNS][2] = oAngle[2]
	SpnTeam[SPAWNS] = iTeam
	set_user_origin(id, SPAWN[SPAWNS])
	
	client_print(id, print_console, "[CSDM] There are now %d spawns defined.", SPAWNS)
	
	return PLUGIN_HANDLED
}

public csdm_setspawn(id, level, cid)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	new IDVec[3]
	new Text[64]
	new Float:vAngle[3]
	new Float:oAngle[3]
	new team[4]
	new iTeam
	
	read_argv(1, team, 4)
	iTeam = str_to_num(team)
	
	if (SPAWNS == 0 || !SPAWNS_ENABLED) {
		SPAWNS_ENABLED = 1
	}
	if (SPAWNS == MAX_SPAWNS) {
		client_print(id, print_console, "[CSDM] Spawn limit reached at %d.", MAX_SPAWNS)
		
		return PLUGIN_HANDLED
	}
	
	get_user_origin(id, IDVec)
	entity_get_vector(id, EV_VEC_v_angle, vAngle)
	entity_get_vector(id, EV_VEC_angles, oAngle)
	IDVec[2] += 15
	format(Text, 64, "%d %d %d %d %d %d %d %d %d %d", IDVec[0], IDVec[1], IDVec[2], floatround(vAngle[0]), floatround(vAngle[1]), floatround(vAngle[2]), iTeam, floatround(oAngle[0]), floatround(oAngle[1]), floatround(oAngle[2]))
	write_file(mapFile, Text, -1)
	SPAWNS++
	SPAWN[SPAWNS][0] = IDVec[0]
	SPAWN[SPAWNS][1] = IDVec[1]
	SPAWN[SPAWNS][2] = IDVec[2]
	SpnVec[SPAWNS][0] = vAngle[0]
	SpnVec[SPAWNS][1] = vAngle[1]
	SpnVec[SPAWNS][2] = vAngle[2]
	SpnAng[SPAWNS][0] = oAngle[0]
	SpnAng[SPAWNS][1] = oAngle[1]
	SpnAng[SPAWNS][2] = oAngle[2]
	SpnTeam[SPAWNS] = iTeam
	set_user_origin(id, SPAWN[SPAWNS])
	
	client_print(id, print_console, "[CSDM] There are now %d spawns defined.", SPAWNS)
	
	return PLUGIN_HANDLED
}

public csdm_hidespawns(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	new tEnt
	
	tEnt = find_ent_by_class(-1, "view_spawn")
	while (tEnt > 0) {
		safe_rm_ent(tEnt)
		tEnt = find_ent_by_class(-1, "view_spawn")
	}
	
	client_print(id, print_console, "[CSDM] Spawn markers removed.")
	
	return PLUGIN_HANDLED
}

public csdm_spawncount(id, level, cid)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	new tEnt, tfEnt
	new i=0
	
	tEnt = find_ent_by_class(-1, "info_player_deathmatch")
	while (tEnt > 0) {
		tfEnt = find_ent_by_class(tEnt, "info_player_deathmatch")
		tEnt = tfEnt
		i++
	}
	
	tEnt = find_ent_by_class(-1, "info_player_start")
	while (tEnt > 0) {
		tfEnt = find_ent_by_class(tEnt, "info_player_start")
		tEnt = tfEnt
		i++
	}
	
	console_print(id, "[CSDM] %d spawns found.", i)
	
	return PLUGIN_HANDLED
}

public csdm_viewspawns(id, level, cid)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	new entid, Float:Ang[3], Float:Vec[3], Float:vAng[3]
	new tEnt, tfEnt
	new i=0
	
	tEnt = find_ent_by_class(-1, "info_player_deathmatch")
	while (tEnt > 0) {
		tfEnt = find_ent_by_class(tEnt, "info_player_deathmatch")
		entity_get_vector(tEnt, EV_VEC_angles, Ang)
		entity_get_vector(tEnt, EV_VEC_origin, Vec)
		entity_get_vector(tEnt, EV_VEC_v_angle, vAng)
		entid = create_entity("info_target")
		entity_set_string(entid, EV_SZ_classname, "view_spawn")
		entity_set_model(entid, "models/w_suit.mdl")
		entity_set_origin(entid, Vec)
		entity_set_vector(entid, EV_VEC_angles, Ang)
		entity_set_vector(entid, EV_VEC_v_angle, vAng)
		entity_set_int(entid, EV_INT_solid, 1)
		entity_set_int(entid, EV_INT_movetype, 6)
		tEnt = tfEnt
		i++
	}
	
	tEnt = find_ent_by_class(-1, "info_player_start")
	while (tEnt > 0) {
		tfEnt = find_ent_by_class(tEnt, "info_player_start")
		entity_get_vector(tEnt, EV_VEC_angles, Ang)
		entity_get_vector(tEnt, EV_VEC_origin, Vec)
		entity_get_vector(tEnt, EV_VEC_v_angle, vAng)
		entid = create_entity("info_target")
		entity_set_string(entid, EV_SZ_classname, "view_spawn")
		entity_set_model(entid, "models/gman.mdl")
		entity_set_origin(entid, Vec)
		entity_set_vector(entid, EV_VEC_angles, Ang)
		entity_set_vector(entid, EV_VEC_v_angle, vAng)
		entity_set_int(entid, EV_INT_solid, 1)
		entity_set_int(entid, EV_INT_movetype, 6)
		tEnt = tfEnt
		i++
	}
	
	console_print(id, "[CSDM] %d spawns marked.", i)
	
	return PLUGIN_HANDLED
}

public csdm_setent(id, level, cid)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	if (EntCount == MAX_ENTS) {
		client_print(id, print_console, "[CSDM] Entity limit reached at %d", MAX_ENTS)
		
		return PLUGIN_HANDLED
	}
	
	if (get_cvar_num("csdm_add_items") != 1) {
		client_print(id, print_console, "[CSDM] You must have csdm_add_items set to 1.")
		client_print(id, print_console, "[CSDM] Set it to 1 and restart the map.")
		
		return PLUGIN_HANDLED
	}
	
	new IDVec[3]
	new gEnt[24]
	new Text[64]
	
	read_argv(1, gEnt, 24)
	get_user_origin(id, IDVec)
	format(Text, 64, "%s %d %d %d", gEnt, IDVec[0], IDVec[1], IDVec[2])
	
	copy(EntList[EntCount], 24, gEnt)
	EntVecs[EntCount][0] = IDVec[0]
	EntVecs[EntCount][1] = IDVec[1]
	EntVecs[EntCount][2] = IDVec[2]
	EntId[EntCount] = makeEnt(EntCount)

	if (EntId[EntCount] > 0) {
		write_file(EntFile, Text, -1)
		EntCount++
		client_print(id, print_console, "[CSDM] There are now %d entities defined.", EntCount)
	} else {
		client_print(id, print_console, "[CSDM] Entity ^"%s^" did not init properly.", gEnt)
		EntVecs[EntCount][0] = 0
		EntVecs[EntCount][1] = 0
		EntVecs[EntCount][2] = 0
		EntId[EntCount] = 0
		copy(EntList[EntCount], 24, "")
	}
	
	return PLUGIN_HANDLED
}

public csdm_items(id, level, cid)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_C)) {
		return PLUGIN_HANDLED
	}
	
	new Bits[4], bit
	
	read_argv(1, Bits, 4)
	bit = str_to_num(Bits)
	
	if (!strlen(Bits)) {
		client_print(id, print_console, "csdm_items [1|0] (1=on, 0=off)")
		return PLUGIN_HANDLED
	}
	
	if (bit == 0) {
		set_cvar_num("csdm_add_items", 0)
		client_print(id, print_console, "Item mode has been turned off.  Reverting to menus.")
		destroyAllItems()
		return PLUGIN_HANDLED
	} else {
		set_cvar_num("csdm_add_items", 1)
		client_print(id, print_console, "Item mode has been turned on.  There may be lag as the items are initialized.")
		setEnts()
		if (get_cvar_num("csdm_allow_clguns")) {
			client_print(id, print_console, "csdm_allow_clguns is chaotic in csdm_add_items mode and is being turned off.")
			set_cvar_num("csdm_allow_clguns", 0)
		}
		return PLUGIN_HANDLED
	}
	return PLUGIN_HANDLED
}

public csdm_onoff(id, level, cid)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_C)) {
		return PLUGIN_HANDLED
	}
	
	new Bits[4], bit
	
	read_argv(1, Bits, 4)
	bit = str_to_num(Bits)
	
	if (!strlen(Bits)) {
		client_print(id, print_console, "csdm_enable [1|0] (1=on, 0=off)")
		return PLUGIN_HANDLED
	}
	
	if (bit == 0) {
		set_cvar_num("csdm_active", 0)
		console_print(id, "CSDM Mode turned off.")
		console_print(id, "There may be some lag as the map is prepared.")
		client_print(0, print_chat, "* 死亡竞赛被关闭, 恢复游戏默认规则.")
		log_amx("[CSDM] CSDM Mode turned off.")
		destroyAllItems()
		restoreSpawns()
		restoreHostages()
		server_cmd("sv_restartround 2")
		return PLUGIN_HANDLED
	} else {
		set_cvar_num("csdm_active", 1)
		console_print(id, "CSDM Mode turned on.")
		client_print(0, print_chat, "* 死亡竞赛被开启, 祝你玩得愉快!")
		log_amx("[CSDM] CSDM Mode turned on.")
		console_print(id, "There may be some lag as the map is prepared.")
		set_task(2.0, "start_map")
		return PLUGIN_HANDLED
	}
		
	return PLUGIN_HANDLED
}

bool:checkMod()
{
	new mod[16]
	
	get_modname(mod, 16)
	
	if (!equali(mod, "cstrike") && !equali(mod, "czero")) {
		log_amx("[CSDM] Not running on cstrike/czero, plugin disabled.")
		set_cvar_string("csdm_active", "0")
		
		return false
	} else {
		if (get_cvar_num("csdm_active")==1) {
			set_cvar_num("mp_freezetime", 0)
			if (get_cvar_num("csdm_kill_all")) {
				if (get_cvar_num("mp_tkpunish")>0) {
					set_cvar_num("mp_tkpunish", 0)
				}
				if (get_cvar_num("mp_autokick")>0) {
					set_cvar_num("mp_autokick", 0)
				}
				if (get_cvar_num("mp_autoteambalance")>0) {
					set_cvar_num("mp_autoteambalance",0)
				}
				if (get_cvar_num("mp_friendlyfire")!=1) {
					set_cvar_num("mp_friendlyfire", 1)
				}
			}
			set_msg_block(get_user_msgid("TextMsg"), BLOCK_SET)
			if (!get_cvar_num("csdm_allow_radio")) {
				set_msg_block(get_user_msgid("SendAudio"), BLOCK_SET)
			}
		}
	}
	
	return true
}

bool:cwrap(string1[], string2[])
{
	if (containi(string1, string2)!=-1) {
		return true
	}
		
	return false
}

//This is basically the reverse of the setSpawns() algorithm
//Basically, it finds all of the spawns in play and 
restoreSpawns()
{
	new tEnt
	new i

	if (SPAWNS_ENABLED) {
		for (i=0; i<OLD_SPAWNS; i++) {
			tEnt = OldSpawnIDs[i]
			if (tEnt) {
				entity_set_origin(tEnt, OldSpawns[i])
				entity_set_vector(tEnt, EV_VEC_v_angle, OldSpawnVecs[i])
				entity_set_vector(tEnt, EV_VEC_angles, OldSpawnAngs[i])
			}
		}
	}
	OLD_SPAWNS = 0
}

//The new spawning engine
setSpawns()
{
	new OldSpawnEnts[MAX_SPAWNS]
	new OldSpawnTeams[MAX_SPAWNS]
	new tEnt, tfEnt, t=0
	new Float:Vec[3]
	new f, g, i
	
	if (SPAWNS_ENABLED && get_cvar_num("csdm_active")) {
		//Find old spawn points to move 'round
		tEnt = find_ent_by_class(-1, "info_player_start")
		while (tEnt > 0 && t<=50) {
			tfEnt = find_ent_by_class(tEnt, "info_player_start")
			OldSpawnEnts[t] = tEnt
			OldSpawnTeams[t] = 2
			tEnt = tfEnt
			t++
		}
		tEnt = find_ent_by_class(-1, "info_player_deathmatch")
		while (tEnt > 0 && t<=50) {
			tfEnt = find_ent_by_class(tEnt, "info_player_deathmatch")
			OldSpawnEnts[t] = tEnt
			OldSpawnTeams[t] = 1
			tEnt = tfEnt
			t++
		}
		
		new chosen[MAX_SPAWNS], s
		
		for (i=1; i<=SPAWNS && i<=t; i++) {
			f = random_num(1, SPAWNS)
			while (chosen[f]) {
				f = random_num(1, SPAWNS)
			}
			chosen[f] = 1
			IVecFVec(SPAWN[f], Vec)
			if (SpnTeam[f] == 1) {
				g = 1
			} else if (SpnTeam[f] == 2) {
				g = 2
			} else {
				g = i%2 + 1
			}
			s = findNextSpawn(OldSpawnTeams, g)
			tEnt = OldSpawnEnts[s]
			OldSpawnIDs[s] = tEnt	//Record the entity # of this old spawn! this old spawn.
			OldSpawnEnts[s] = 0
			OLD_SPAWNS++			//Increase number of old spawns found!
			if (is_valid_ent(tEnt)) {
				//We have a valid entity.  Save the original data.
				entity_get_vector(tEnt, EV_VEC_origin, OldSpawns[s])
				entity_get_vector(tEnt, EV_VEC_v_angle, OldSpawnVecs[s])
				entity_get_vector(tEnt, EV_VEC_angles, OldSpawnAngs[s])
				//NOW we can set the new values.
				entity_set_origin(tEnt, Vec)
				entity_set_vector(tEnt, EV_VEC_v_angle, SpnVec[f])
				entity_set_vector(tEnt, EV_VEC_angles, SpnAng[f])
			}
		}
		
		if (!get_cvar_num("csdm_steam")) {
			for (i=1; i<MAX_SPAWNS; i++) {
				if (OldSpawnEnts[s]) {
					remove_entity(OldSpawnEnts[s])
				}
			}
		}
	}
}

findNextSpawn(Ents[MAX_SPAWNS], team)
{
	new i
	for (i=1; i<MAX_SPAWNS; i++) {
		if (Ents[i] == team) {
			Ents[i] = 0
			return i
		}
	}
	
	return 0
}

setEnts()
{
	new i
	if ((get_cvar_num("csdm_add_items")) && EntCount && get_cvar_num("csdm_active")) {
		for (i=0; i<EntCount; i++) {
			EntId[i] = makeEnt(i)
		}
	}
}

makeWeapon(wp, Float:Origin[3], Float:Angles[3]={0.0,0.0,0.0}, Float:Vel[3]={0.0,0.0,0.0})
{
	new model_name[32]
	new name[20]
	
	if (isWpBlocked(wp)) {
		return 0
	}
	
	getWepModel(wp, model_name, 32)
	getCSDMWp(wp, name, 20)
	
	new entid = mkent()
	if (entid) {
		entity_set_string(entid, EV_SZ_classname, name)
		entity_set_model(entid, model_name)
		entity_set_origin(entid, Origin)
		entity_set_int(entid, EV_INT_solid, 1)
		entity_set_int(entid, EV_INT_movetype, 6)
		//entity_set_edict(entid, EV_ENT_groundentity, 1)
		entity_set_edict(entid, EV_ENT_groundentity, entid)
		entity_set_vector(entid, EV_VEC_angles, Angles)
		entity_set_vector(entid, EV_VEC_velocity, Vel)
	} else {
		entid = 0
	}
	
	return entid
}

makeEnt(id)
{
	new Float:Vec[3]
	new entid
	
	IVecFVec(EntVecs[id], Vec)
	
	if ((!(get_cvar_num("csdm_active"))) || (!(get_cvar_num("csdm_add_items")))) {
		return 0
	}
	
	if (cwrap(EntList[id], "weapon_")) {
		new wp = getWepId(EntList[id])
		entid = makeWeapon(wp, Vec)
	} else if (cwrap(EntList[id], "item_longjump")) {
		entid = mkent()
		if (entid) {
			entity_set_string(entid, EV_SZ_classname, "csdm_longjump")
			entity_set_model(entid, "models/w_longjump.mdl")
			entity_set_origin(entid, Vec)
			entity_set_int(entid, EV_INT_solid, 1)
			entity_set_int(entid, EV_INT_movetype, 6)
			//entity_set_edict(entid, EV_ENT_groundentity, 1)
			entity_set_edict(entid, EV_ENT_groundentity, entid)
		}
	} else if (cwrap(EntList[id], "item_healthkit")) {
		entid = mkent()
		if (entid) {
			entity_set_string(entid, EV_SZ_classname, "csdm_medkit")
			entity_set_model(entid, "models/w_medkit.mdl")
			entity_set_origin(entid, Vec)
			entity_set_int(entid, EV_INT_solid, 1)
			entity_set_int(entid, EV_INT_movetype, 6)
			//entity_set_edict(entid, EV_ENT_groundentity, 1)
			entity_set_edict(entid, EV_ENT_groundentity, entid)
		}
	} else if (cwrap(EntList[id], "item_battery")) {
		entid = mkent()
		if (entid) {
			entity_set_string(entid, EV_SZ_classname, "csdm_battery")
			entity_set_model(entid, "models/w_battery.mdl")
			entity_set_origin(entid, Vec)
			entity_set_int(entid, EV_INT_solid, 1)
			entity_set_int(entid, EV_INT_movetype, 6)
			//entity_set_edict(entid, EV_ENT_groundentity, 1)
			entity_set_edict(entid, EV_ENT_groundentity, entid)
		}
	} else if (cwrap(EntList[id], "pistol_ammo")) {
		entid = mkent()
		if (entid) {
			entity_set_string(entid, EV_SZ_classname, "csdm_pistolammo")
			entity_set_model(entid, "models/w_357ammobox.mdl")
			entity_set_origin(entid, Vec)
			entity_set_int(entid, EV_INT_solid, 1)
			entity_set_int(entid, EV_INT_movetype, 6)
			//entity_set_edict(entid, EV_ENT_groundentity, 1)
			entity_set_edict(entid, EV_ENT_groundentity, entid)
		}
	} else if (cwrap(EntList[id], "rifle_ammo")) {
		entid = mkent()
		if (entid) {
			entity_set_string(entid, EV_SZ_classname, "csdm_rifleammo")
			entity_set_model(entid, "models/w_9mmarclip.mdl")
			entity_set_origin(entid, Vec)
			entity_set_int(entid, EV_INT_solid, 1)
			entity_set_int(entid, EV_INT_movetype, 6)
			//entity_set_edict(entid, EV_ENT_groundentity, 1)
			entity_set_edict(entid, EV_ENT_groundentity, entid)
		}
	} else if (cwrap(EntList[id], "shotgun_ammo")) {
		entid = mkent()
		if (entid) {
			entity_set_string(entid, EV_SZ_classname, "csdm_shotammo")
			entity_set_model(entid, "models/w_shotbox.mdl")
			entity_set_origin(entid, Vec)
			entity_set_int(entid, EV_INT_solid, 1)
			entity_set_int(entid, EV_INT_movetype, 6)
			//entity_set_edict(entid, EV_ENT_groundentity, 1)
			entity_set_edict(entid, EV_ENT_groundentity, entid)
		}
	} else if (cwrap(EntList[id], "smg_ammo")) {
		entid = mkent()
		if (entid) {
			entity_set_string(entid, EV_SZ_classname, "csdm_smgammo")
			entity_set_model(entid, "models/w_9mmclip.mdl")
			entity_set_origin(entid, Vec)
			entity_set_int(entid, EV_INT_solid, 1)
			entity_set_int(entid, EV_INT_movetype, 6)
			//entity_set_edict(entid, EV_ENT_groundentity, 1)
			entity_set_edict(entid, EV_ENT_groundentity, entid)
		}
	} else if (cwrap(EntList[id], "full_ammo")) {
		entid = mkent()
		if (entid) {
			entity_set_string(entid, EV_SZ_classname, "csdm_fullammo")
			if (get_cvar_num("csdm_asskicr")) {
				entity_set_model(entid, "models/w_isotopebox.mdl")
			} else {
				entity_set_model(entid, "models/w_chainammo.mdl")
			}
			entity_set_origin(entid, Vec)
			entity_set_int(entid, EV_INT_solid, 1)
			entity_set_int(entid, EV_INT_movetype, 6)
			//entity_set_edict(entid, EV_ENT_groundentity, 1)
			entity_set_edict(entid, EV_ENT_groundentity, entid)
		}
	} else if (cwrap(EntList[id], "armor")) {
		entid = mkent()
		if (entid) {
			entity_set_string(entid, EV_SZ_classname, "csdm_armor")
			entity_set_model(entid, "models/w_assault.mdl")
			entity_set_origin(entid, Vec)
			entity_set_int(entid, EV_INT_solid, 1)
			entity_set_int(entid, EV_INT_movetype, 6)
			//entity_set_edict(entid, EV_ENT_groundentity, 1)
			entity_set_edict(entid, EV_ENT_groundentity, entid)
		}
	} else if (cwrap(EntList[id], "awp_ammo")) {
		if (get_cvar_num("csdm_asskicr")) {
			entid = mkent()
			if (entid) {
				entity_set_string(entid, EV_SZ_classname, "csdm_awpammo")
				entity_set_model(entid, "models/w_crossbow_clip.mdl")
				entity_set_origin(entid, Vec)
				entity_set_int(entid, EV_INT_solid, 1)
				entity_set_int(entid, EV_INT_movetype, 6)
				//entity_set_edict(entid, EV_ENT_groundentity, 1)
				entity_set_edict(entid, EV_ENT_groundentity, entid)
			}
		}
	} else if (cwrap(EntList[id], "para_ammo")) {
		if (get_cvar_num("csdm_asskicr")) {
			entid = mkent()
			if (entid) {
				entity_set_string(entid, EV_SZ_classname, "csdm_paraammo")
				entity_set_model(entid, "models/w_chainammo.mdl")
				entity_set_origin(entid, Vec)
				entity_set_int(entid, EV_INT_solid, 1)
				entity_set_int(entid, EV_INT_movetype, 6)
				//entity_set_edict(entid, EV_ENT_groundentity, 1)
				entity_set_edict(entid, EV_ENT_groundentity, entid)
			}
		}
	} else {
		entid = mkent(EntList[id])
		if (entid) {
			entity_set_string(entid, EV_SZ_classname, EntList[id])
			entity_set_origin(entid, Vec)
		}
	}
	

	if (entid) {
		return entid
	} else {
		return 0
	}
	
	return entid
}

readEntsFile()
{
	new Map[49]
	new Text[192]
	
	get_mapname(Map, 48)
	if (get_cvar_num("csdm_asskicr")) {
		format(EntFile, 59, "addons\amxmodx\configs\csdm\asskicr\ents_%s.cfg", Map)
	}else{
		format(EntFile, 59, "addons\amxmodx\configs\csdm\ents_%s.cfg", Map)
	}
	EntCount = 0
	if (file_exists(EntFile)) {
		new i=0, temp
		new Data[32]
		new x,y,z
		new Name[32]
		new TempB1[32]
		new TempB2[32]
		new TempB3[32]
		while (i<MAX_ENTS && read_file(EntFile, i, Data, 32, temp)) {
			strbreak(Data, Name, 32, TempB3, 32)
			strbreak(TempB3, TempB1, 32, TempB2, 32)
			x = str_to_num(TempB1)
			strbreak(TempB2, TempB1, 32, TempB3, 32)
			y = str_to_num(TempB1)
			strbreak(TempB3, TempB1, 32, TempB2, 32)
			z = str_to_num(TempB1)
			if (strlen(Name)>2) {
				EntCount++
				EntVecs[EntCount][0] = x
				EntVecs[EntCount][1] = y
				EntVecs[EntCount][2] = z
				copy(EntList[EntCount], 24, Name)
			}
			i++
		}
		format(Text, 192, "[CSDM] loaded %d entities for %s.", EntCount, Map)
		EntCount++	//Move the entity pointer up by one
		log_amx(Text)
	} else {
		format(Text, 192, "[CSDM] warning: map %s not set up for entities.", Map)
		log_amx(Text)
		EntCount = 0
	}
}

readWeaponsFile()
{
	new FileName[] = "addons\amxmodx\configs\csdm\blocked.cfg"
	new Data[48], temp
	new log[192]
	new Name[24], Number[24]
	new temp2[32]
	
	new ptr = 0, i
	if (file_exists(FileName)) {
		while (i<MAX_RESTRICTS && read_file(FileName, i, Data, 48, temp)) {
			if (strlen(Data) > 3) {
				strbreak(Data, Name, 24, Number, 24)
				format(temp2, 32, "weapon_%s", Name)
				BlockedWps[++ptr] = getWepId(temp2)
				RestrictWps[ptr] = str_to_num(Number)
			}
			i++
		}
		Blocks = ptr
		format(log, 192, "[CSDM] loaded %d weapon blocks.", Blocks)
		log_amx(log)
	}
}

readMapFile()	//taken from Bail's Root Plugin
{
	new Map[32]
	new Text[192]
	new TempB[12][8]
	
	get_mapname(Map, 32)
	if (!get_cvar_num("csdm_steam")) {
		if (cwrap(Map, "de_aztec")) {
			format(mapFile, 48, "addons\amxmodx\configs\csdm\csdm_%s15.cfg", Map)
		} else {
			format(mapFile, 48, "addons\amxmodx\configs\csdm\csdm_%s.cfg", Map)
		}
	} else {
		format(mapFile, 48, "addons\amxmodx\configs\csdm\csdm_%s.cfg", Map)
	}
	SPAWNS = 0
	if (file_exists(mapFile)) {
		SPAWNS_ENABLED = 1
		new i=0, temp
		new Data[128]
		while (SPAWNS<MAX_SPAWNS && read_file(mapFile, i, Data, 128, temp)) {
			if (strlen(Data)>2) {
				parse(Data,TempB[1],8,TempB[2],8,TempB[3],8,TempB[4],8,TempB[5],8,TempB[6],8,TempB[7],8,TempB[8],8,TempB[9],8,TempB[10],8)
				SPAWNS++
				SPAWN[SPAWNS][0] = str_to_num(TempB[1])
				SPAWN[SPAWNS][1] = str_to_num(TempB[2])
				SPAWN[SPAWNS][2] = str_to_num(TempB[3])
				SpnVec[SPAWNS][0] = float(str_to_num(TempB[4]))
				SpnVec[SPAWNS][1] = float(str_to_num(TempB[5]))
				SpnVec[SPAWNS][2] = float(str_to_num(TempB[6]))
				SpnTeam[SPAWNS] = str_to_num(TempB[7])
				SpnAng[SPAWNS][0] = float(str_to_num(TempB[8]))
				SpnAng[SPAWNS][1] = float(str_to_num(TempB[9]))
				SpnAng[SPAWNS][2] = float(str_to_num(TempB[10]))
			}
			i++
		}
		format(Text, 192, "[CSDM] loaded %d spawns for %s.", SPAWNS, Map)
		log_amx(Text)
	} else {
		format(Text, 192, "[CSDM] warning: map %s not set up for spawn points.", Map)
		log_amx(Text)
		SPAWNS_ENABLED = 0
	}
}

public giveGun(id,wpn,s)
{
	new wpn_id[32], num
	new wepname[32]
	new i
	num = 0
	get_user_weapons(id,wpn_id,num)
	for(i = 0; i<num; i++)
	{
		if(wpn_id[i] != wpn)
		{
			if (canGetGun(id, wpn)) {
				get_weaponname(wpn,wepname,31)
				if(is_user_alive(id)) {
					while (canGetGun(id, wpn)) {
						give_item(id, wepname)
					}
				}
				if (s==1) {
					g_LastWep[id][0] = wpn
				} else if (s==0) {
					g_LastWep[id][1] = wpn
				}
			} else {
				new n
				for (n=0; n<num; n++) {
					if (getWepSlot(wpn_id[i]) == getWepSlot(wpn)) {
						new name[32], drop[3]
						
						get_weaponname(wpn_id[i], name, 31)
						client_cmd(id, "drop %s", name)
						drop[0] = wpn_id[i]
						drop[1] = 1
						drop[2] = id
						set_task(0.2, "timed_replace", 0, drop, 3)
					}
				}
				get_weaponname(wpn,wepname,31)
				if(is_user_alive(id)) {
					while (canGetGun(id, wpn)) {
						give_item(id, wepname)
					}
				}
				if (s==1) {
					g_LastWep[id][0] = wpn
				} else if (s==0) {
					g_LastWep[id][1] = wpn
				}
			}
		}
	}
	return PLUGIN_HANDLED
}

public ArmorMenu(id)
{
	if (is_user_alive(id)) {
		if (get_cvar_num("csdm_enable_amenu")) {
			new menuBody[192]
			new key
			
			format(menuBody, 192, "\rCSDM: 防弹衣\R^n^n\y1.\w 新防弹衣^n\y2.\w 不使用")
			key = (1<<0)|(1<<1)
			
			show_menu(id, key, menuBody)
		} else {
			GrenadeMenu(id)
		}
	}
}

public GrenadeMenu(id)
{
	if (is_user_alive(id) && get_cvar_num("csdm_enable_gmenu")) {
		new menuBody[192]
		new key
		
		format(menuBody, 192, "\rCSDM: 辅助装备\R^n^n\y1.\w 全部手雷^n\y2.\w 不使用")
		key = (1<<0)|(1<<1)
		
		show_menu(id, key, menuBody)
	}
}

public EquipMenu(id)
{
	if (is_user_alive(id)) {
		new menuBody[192] 
		new key
		
		format(menuBody, 192, "\rCSDM: 装备选择菜单\R^n^n\y1.\w 重新选择武器^n\y2.\w 使用上次的武器配置^n\y3.\w 一直使用上次的武器并不再提示")
		key = (1<<0)|(1<<1)|(1<<2)
		
		show_menu(id, key, menuBody)
	}
}

public pWeaponMenu(id,mpage)	//By Freecode
{
	g_MenuPos[id] = mpage
	new menuBody[1024]
	new len
	new key
	if(mpage == 1)
	{
		if (get_cvar_num("csdm_steam")) {
			len = format(menuBody,1023,"\rCSDM: 选择主要武器\R^n^n\y1.\w M4A1^n\y2.\w AK47^n\y3.\w AUG^n\y4.\w SG552^n\y5.\w Galil^n\y6.\w Famas")
			len += format(menuBody[len],1023-len,"^n^n\y7.\w 下一页^n\y8.\w 不使用")
			key = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)
		} else {
			len = format(menuBody,1023,"\rCSDM: 选择主要武器\R^n^n\y1.\w M4A1^n\y2.\w AK47^n\y3.\w AUG^n\y4.\w SG552")
			len += format(menuBody[len],1023-len,"^n^n\y5.\w 下一页^n\y6.\w 不使用")
			key = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)
		}
	}
	else if(mpage == 2)
	{
		len = format(menuBody,1023,"\rCSDM: 选择主要武器\R^n^n\y1.\w Scout^n\y2.\w AWP^n\y3.\w SG550^n\y4.\w M249^n\y5.\w G3SG1^n^n\y6.\w 上一页^n\y7.\w 下一页")
		len += format(menuBody[len],1023-len,"^n\y8.\w 不使用")
		key = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)
	}
	else if(mpage == 3)
	{
		len = format(menuBody,1023,"\rCSDM: 选择主要武器\R^n^n\y1.\w UMP 45^n\y2.\w MP5 Navy^n\y3.\w M3^n\y4.\w XM1014^n\y5.\w TMP^n\y6.\w Mac 10")
		len += format(menuBody[len],1023-len,"^n\y7.\wP90^n^n\y8.\w 上一页^n\y9.\w 不使用")
		key = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)
	}
	show_menu(id,key,menuBody)
}

public sWeaponMenu(id)	//By Freecode
{
	new menuB[1024]
	new key
	format(menuB,1023,"\rCSDM: 选择辅助武器\R^n^n\y1.\w USP^n\y2.\w Glock^n\y3.\w Deagle^n\y4.\w P228t^n\y5.\w Elite^n\y6.\w Five Seven^n^n\y7.\w 不使用")
	key = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)
	show_menu(id,key,menuB)
}

public ArmorChoice(id, key)
{
	switch(key)
	{
		case 0:
		{
			set_user_armor(id, 100)
			give_item(id, "item_assaultsuit")
			g_getArmor[id] = true
		}
		case 1:
		{
			g_getArmor[id] = false
		}	
	}
	GrenadeMenu(id)
}

public GrenChoice(id, key)
{
	switch(key)
	{
		case 0:
		{
			give_item(id, "weapon_hegrenade")
			give_item(id, "weapon_flashbang")
			give_item(id, "weapon_flashbang")
			give_item(id, "weapon_smokegrenade")
			g_getGrens[id] = true
		}
		case 1:
		{
			g_getGrens[id] = false
		}
	}
}


public EquipChoice(id, key)
{
	switch(key)
	{
		case 0:
		{
			sWeaponMenu(id)
		}
		case 1:
		{
			giveGun(id, g_LastWep[id][0], 1)
			giveGun(id, g_LastWep[id][1], 0)
		}
		case 2:
		{
			giveGun(id, g_LastWep[id][0], 1)
			giveGun(id, g_LastWep[id][1], 0)
			ShowMenu[id] = false
			client_print(id, print_chat, "[CSDM] 你可以输入 ^"enable_menu^" 或者 ^"guns^" 重新开启选枪菜单.")
		}
	}
}

public PrimaryWeapon(id,key)	//By Freecode
{
	Swep[id] = false
	if(g_MenuPos[id] == 1)
	{
		switch (key)
		{
			case 0:
			{
				if (isWpBlocked(CSW_M4A1) || isWpOverload(id, CSW_M4A1)) {
					client_print(id, print_chat, "[CSDM] 你所选择的武器现在不可用!")
					pWeaponMenu(id, 1)
				} else {
					giveGun(id,CSW_M4A1,0)
					ArmorMenu(id)
				}
			}
			case 1: 
			{
				if (isWpBlocked(CSW_AK47) || isWpOverload(id, CSW_AK47)) {
					client_print(id, print_chat, "[CSDM] 你所选择的武器现在不可用!")
					pWeaponMenu(id, 1)
				} else {
					giveGun(id,CSW_AK47,0)
					ArmorMenu(id)
				}
			}
			case 2: 
			{
				if (isWpBlocked(CSW_AUG) || isWpOverload(id, CSW_AUG)) {
					client_print(id, print_chat, "[CSDM] 你所选择的武器现在不可用!")
					pWeaponMenu(id, 1)
				} else {
					giveGun(id,CSW_AUG,0)
					ArmorMenu(id)
				}
			}
			case 3:
			{
				if (isWpBlocked(CSW_SG552) || isWpOverload(id, CSW_SG552)) {
					client_print(id, print_chat, "[CSDM] 你所选择的武器现在不可用!")
					pWeaponMenu(id, 1)
				} else {
					giveGun(id,CSW_SG552,0)
					ArmorMenu(id)
				}
			}
			case 4:
			{
				if (get_cvar_num("csdm_steam")) {
					if (isWpBlocked(CSW_GALIL) || isWpOverload(id, CSW_GALIL)) {
						client_print(id, print_chat, "[CSDM] 你所选择的武器现在不可用!")
						pWeaponMenu(id, 1)
					} else {
						giveGun(id,CSW_GALIL,0)
						ArmorMenu(id)
					}
				} else {
					pWeaponMenu(id, 2)
				}
			}
			case 5:
			{
				if (get_cvar_num("csdm_steam")) {
					if (isWpBlocked(CSW_FAMAS) || isWpOverload(id, CSW_FAMAS)) {
						client_print(id, print_chat, "[CSDM] 你所选择的武器现在不可用!")
						pWeaponMenu(id, 1)
					} else {				
						giveGun(id,CSW_FAMAS,0)
						ArmorMenu(id)
					}
				} else {
					ArmorMenu(id)
				}
			}
			case 6: pWeaponMenu(id,2)
			case 7: ArmorMenu(id)
		}
	}
	else if(g_MenuPos[id] == 2)
	{
		switch (key)
		{
			case 0:
			{
				if (isWpBlocked(CSW_SCOUT) || isWpOverload(id, CSW_SCOUT)) {
					client_print(id, print_chat, "[CSDM] 你所选择的武器现在不可用!")
					pWeaponMenu(id, 1)
				} else {
					giveGun(id,CSW_SCOUT,0)
					ArmorMenu(id)
				}
			}
			case 1:
			{
				if (isWpBlocked(CSW_AWP) || isWpOverload(id, CSW_AWP)) {
					client_print(id, print_chat, "[CSDM] 你所选择的武器现在不可用!")
					pWeaponMenu(id, 1)
				} else {
					giveGun(id,CSW_AWP,0)
					ArmorMenu(id)
				}
			}
			case 2:
			{
				if (isWpBlocked(CSW_SG550) || isWpOverload(id, CSW_SG550)) {
					client_print(id, print_chat, "[CSDM] 你所选择的武器现在不可用!")
					pWeaponMenu(id, 1)
				} else {
					giveGun(id,CSW_SG550,0)
					ArmorMenu(id)
				}
			}
			case 3:
			{
				if (isWpBlocked(CSW_M249) || isWpOverload(id, CSW_M249)) {
					client_print(id, print_chat, "[CSDM] 你所选择的武器现在不可用!")
					pWeaponMenu(id, 1)
				} else {
					giveGun(id,CSW_M249,0)
					ArmorMenu(id)
				}
			}
			case 4:
			{
				if (isWpBlocked(CSW_G3SG1) || isWpOverload(id, CSW_G3SG1)) {
					client_print(id, print_chat, "[CSDM] 你所选择的武器现在不可用!")
					pWeaponMenu(id, 1)
				} else {
					giveGun(id,CSW_G3SG1,0)
					ArmorMenu(id)
				}
			}
			case 5: pWeaponMenu(id,1)
			case 6: pWeaponMenu(id,3)
			case 7: ArmorMenu(id)
		}
	}
	else if(g_MenuPos[id] == 3)
	{
		switch (key)
		{
			case 0:
			{
				if (isWpBlocked(CSW_UMP45) || isWpOverload(id, CSW_UMP45)) {
					client_print(id, print_chat, "[CSDM] 你所选择的武器现在不可用!")
					pWeaponMenu(id, 1)
				} else {
					giveGun(id,CSW_UMP45,0)
					ArmorMenu(id)
				}
			}
			case 1:
			{
				if (isWpBlocked(CSW_MP5NAVY) || isWpOverload(id, CSW_MP5NAVY)) {
					client_print(id, print_chat, "[CSDM] 你所选择的武器现在不可用!")
					pWeaponMenu(id, 1)
				} else {
					giveGun(id,CSW_MP5NAVY,0)
					ArmorMenu(id)
				}
			}
			case 2:
			{
				if (isWpBlocked(CSW_M3) || isWpOverload(id, CSW_M3)) {
					client_print(id, print_chat, "[CSDM] 你所选择的武器现在不可用!")
					pWeaponMenu(id, 1)
				} else {
					giveGun(id,CSW_M3,0)
					ArmorMenu(id)
				}
			}
			case 3:
			{
				if (isWpBlocked(CSW_XM1014) || isWpOverload(id, CSW_XM1014)) {
					client_print(id, print_chat, "[CSDM] 你所选择的武器现在不可用!")
					pWeaponMenu(id, 1)
				} else {
					giveGun(id,CSW_XM1014,0)
					ArmorMenu(id)
				}
			}
			case 4:
			{
				if (isWpBlocked(CSW_TMP) || isWpOverload(id, CSW_TMP)) {
					client_print(id, print_chat, "[CSDM] 你所选择的武器现在不可用!")
					pWeaponMenu(id, 1)
				} else {
					giveGun(id,CSW_TMP,0)
					ArmorMenu(id)
				}
			}
			case 5: 
			{
				if (isWpBlocked(CSW_MAC10) || isWpOverload(id, CSW_MAC10)) {
					client_print(id, print_chat, "[CSDM] 你所选择的武器现在不可用!")
					pWeaponMenu(id, 1)
				} else {
					giveGun(id,CSW_MAC10,0)
					ArmorMenu(id)
				}
			}
			case 6: 
			{
				if (isWpBlocked(CSW_P90) || isWpOverload(id, CSW_P90)) {
					client_print(id, print_chat, "[CSDM] 你所选择的武器现在不可用!")
					pWeaponMenu(id, 1)
				} else {
					giveGun(id,CSW_P90,0)
					ArmorMenu(id)
				}
			}
			case 7: pWeaponMenu(id,2)
			case 8: ArmorMenu(id)
		}
	}
}

public SecondWeapon(id,key)	//By Freecode
{
	Swep[id] = false
	switch (key)
	{
		case 0: 
			{
				giveGun(id,CSW_USP,1)
				pWeaponMenu(id, 1)
			}
		case 1: 
			{
				giveGun(id,CSW_GLOCK18,1)
				pWeaponMenu(id, 1)
			}
		case 2:
			{
				giveGun(id,CSW_DEAGLE,1)
				pWeaponMenu(id, 1)
			}
		case 3: 
			{
				giveGun(id,CSW_P228,1)
				pWeaponMenu(id, 1)
			}
		case 4: 
			{
				giveGun(id,CSW_ELITE,1)
				pWeaponMenu(id, 1)
			}
		case 5:
			{
				giveGun(id,CSW_FIVESEVEN,1)
				pWeaponMenu(id, 1)
			}
		case 6:
			{
				pWeaponMenu(id, 1)
			}
	}
	
}


//public vexd_pfntouch(pToucher, pTouched) {
public pfn_touch(ptr, ptd) {
	//new ptr = pToucher
	//new ptd = pTouched
	new ptrClass[32]
	new ptdClass[32]
	new name[32]
	new Float:Time = get_cvar_float("csdm_item_time")
	new g_wp
	new Item[2], id, x, y
	new i
	if (!is_user_alive(ptd) || !is_valid_ent(ptr) || ptd > 32 || ptd < 1) {
		return PLUGIN_CONTINUE
	}
	entity_get_string(ptr, EV_SZ_classname, ptrClass, 32)
	entity_get_string(ptd, EV_SZ_classname, ptdClass, 32)
//	if (!is_user_alive(ptd) || ptd > 32 || ptd < 1) {
//		return PLUGIN_CONTINUE
//	}
	
	if (cwrap(ptrClass, "csdmw_") && equal(ptdClass, "player")) {
		g_wp = getCSDMWpId(ptrClass)
		get_weaponname(g_wp, name, 32)
		id = findEntId(ptr)
		if (id && g_wp) {
			if (canGetGun(ptd, g_wp)) {
				safe_rm_ent(ptr)
				give_item(ptd, name)
				EntId[id] = 0
				Item[0] = id
				set_task(Time, "replenish", 0, Item, 2)
			}
		} else {
			if (canGetGun(ptd, g_wp)) {
				//Do not replenish, THIS IS A TEMPENT
				new dropid = findDrop(ptr)
				give_item(ptd, name)
				if (dropid) {
					destroyDrop(dropid)
				} else {
					safe_rm_ent(ptr)
				}
			}
		}
	}
	
	if (get_cvar_num("csdm_add_items")!=1) {
		return PLUGIN_CONTINUE
	}
	
	if (cwrap(ptrClass, "csdm_") && equal(ptdClass, "player")) {
		//THIS WEAPON WAS SET IN THE MAP THROUGH CSDM_SETENT - PERMANENT
		id = findEntId(ptr)
		if (id) {
			if (cwrap(EntList[id], "pistol_ammo")) {
				if (canGetAmmo(ptd, PISTOL_AMMO)) {
					giveAmmoType(ptd, PISTOL_AMMO)
					safe_rm_ent(ptr)
					EntId[id] = 0
					Item[0] = id
					set_task(Time, "replenish", 0, Item, 2)
				}
			} else if (cwrap(EntList[id], "shotgun_ammo")) {
				if (canGetAmmo(ptd, SHOTGUN_AMMO)) {
					giveAmmoType(ptd, SHOTGUN_AMMO)
					safe_rm_ent(ptr)
					EntId[id] = 0
					Item[0] = id
					set_task(Time, "replenish", 0, Item, 2)
				}
			} else if (cwrap(EntList[id], "smg_ammo")) {
				if (canGetAmmo(ptd, SMG_AMMO)) {
					giveAmmoType(ptd, SMG_AMMO)
					safe_rm_ent(ptr)
					EntId[id] = 0
					Item[0] = id
					set_task(Time, "replenish", 0, Item, 2)
				}
			} else if (cwrap(EntList[id], "rifle_ammo")) {
				if (canGetAmmo(ptd, RIFLE_AMMO)) {
					giveAmmoType(ptd, RIFLE_AMMO)
					safe_rm_ent(ptr)
					EntId[id] = 0
					Item[0] = id
					set_task(Time, "replenish", 0, Item, 2)
				}
			} else if (cwrap(EntList[id], "full_ammo")) {
					new bool:GetAmmo=false
					if(get_cvar_num("csdm_asskicr")) {
						if (canGetAmmo(ptd, 1) || canGetAmmo(ptd, 2) || canGetAmmo(ptd, 2) || canGetAmmo(ptd, 4) || canGetAmmo(ptd, 5) || canGetAmmo(ptd, 6)) {
							GetAmmo=true
						}
					}else{
						if (canGetAmmo(ptd, 1) || canGetAmmo(ptd, 2) || canGetAmmo(ptd, 2) || canGetAmmo(ptd, 4) ) {
							GetAmmo=true
						}
					}
					if (GetAmmo) {
						if (canGetAmmo(ptd, 1)) giveAmmoType(ptd, PISTOL_AMMO)
						if (canGetAmmo(ptd, 2)) giveAmmoType(ptd, SHOTGUN_AMMO)
						if (canGetAmmo(ptd, 3)) giveAmmoType(ptd, SMG_AMMO)
						if (canGetAmmo(ptd, 4)) giveAmmoType(ptd, RIFLE_AMMO)
						if (get_cvar_num("csdm_asskicr")) {
							if (canGetAmmo(ptd, 5)) giveAmmoType(ptd, AWP_AMMO)
							if (canGetAmmo(ptd, 6)) giveAmmoType(ptd, PARA_AMMO)
						}
						safe_rm_ent(ptr)
						EntId[id] = 0
						Item[0] = id
						set_task(Time, "replenish", 0, Item, 2)
					}
			} else if (cwrap(EntList[id], "armor")) {
				if (get_user_armor(ptd) < 100) {
					give_item(ptd, "item_assaultsuit")
					safe_rm_ent(ptr)
					EntId[id] = 0
					Item[0] = id
					set_task(Time, "replenish", 0, Item, 2)
				}
			} else if (cwrap(EntList[id], "battery")) {
				y = get_cvar_num("csdm_battery")
				x = get_user_armor(ptd)
				if (x < 100) {
					if (x+y > 100) {
						set_user_armor(ptd, 100)
					} else {
						set_user_armor(ptd, x+y)
					}
					if (get_cvar_num("csdm_sounds")) {
						emit_sound(ptr, CHAN_ITEM, "items/gunpickup2.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
					}
					safe_rm_ent(ptr)
					EntId[id] = 0
					Item[0] = id
					set_task(Time, "replenish", 0, Item, 2)
				}
			} else if (cwrap(EntList[id], "healthkit")) {
				y = get_cvar_num("csdm_medkit")
				x = get_user_health(ptd)
				if (x < 100) {
					if (x+y > 100) {
						set_user_health(ptd, 100)
					} else {
						set_user_health(ptd, x+y)
					}
					if (get_cvar_num("csdm_sounds")) {
						emit_sound(ptr, CHAN_ITEM, "items/smallmedkit1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
					}
					safe_rm_ent(ptr)
					EntId[id] = 0
					Item[0] = id
					set_task(Time, "replenish", 0, Item, 2)
				}
			} else if (cwrap(EntList[id], "longjump")) {
				if (!HasLongJump[ptd]) {
					give_item(ptd, "item_longjump")
					HasLongJump[ptd] = true
					if (get_cvar_num("csdm_sounds")) {
						emit_sound(ptr, CHAN_ITEM, "items/clipinsert1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
					}
					safe_rm_ent(ptr)
					EntId[id] = 0
					Item[0] = id
					set_task(Time, "replenish", 0, Item, 2)
					if (get_cvar_num("csdm_explain")) {
						client_print(ptd, print_chat, "[CSDM] 得到辅助推进器, 在移动中按下蹲和跳可以使用推进器!")
					}
				}
			} else if (cwrap(EntList[id], "awp_ammo")) {
				if (get_cvar_num("csdm_asskicr")) {
					if (canGetAmmo(ptd, AWP_AMMO)) {
						giveAmmoType(ptd, AWP_AMMO)
						safe_rm_ent(ptr)
						EntId[id] = 0
						Item[0] = id
						set_task(Time, "replenish", 0, Item, 2)
					}
				}
			} else if (cwrap(EntList[id], "para_ammo")) {
				if (get_cvar_num("csdm_asskicr")) {
					if (canGetAmmo(ptd, PARA_AMMO)) {
						giveAmmoType(ptd, PARA_AMMO)
						safe_rm_ent(ptr)
						EntId[id] = 0
						Item[0] = id
						set_task(Time, "replenish", 0, Item, 2)
					}
				}
			}
		}
	} else if (equali(ptrClass, "drop_pack") && equali(ptdClass, "player")) {
		//Go through pack contents and award bonii
		new pid = findPackId(ptr)
		if (pid) {
			if (get_user_health(ptd)+15>100) {
				set_user_health(ptd, 100)
			} else {
				set_user_health(ptd, get_user_health(ptd)+15)
			}
			if (get_user_armor(ptd)+15>100) {
				set_user_armor(ptd, 100)
			} else {
				set_user_armor(ptd, get_user_armor(ptd)+15)
			}
			if (get_cvar_num("csdm_sounds")) {
				emit_sound(ptd, CHAN_ITEM, "items/ammopickup2.wav", 0.85, ATTN_NORM, 0, 150)
			}
			new iType
			if (get_cvar_num("csdm_asskicr")) {
				iType=6 
			}else{
				iType=4
			}
			for (i=0; i<iType; i++) {
				g_wp = PackAmmo[pid][i]
				if (g_wp) {
					if (canGetGun(ptd, g_wp)) {
						get_weaponname(g_wp, name, 20)
						give_item(ptd, name)
					}
					giveAmmoType(ptd, i+1)
				}
			}
			for (i=0; i<3; i++) {
				g_wp = PackGren[pid][i]
				if (g_wp) {
					if (canGetGun(ptd, g_wp)) {
						get_weaponname(g_wp, name, 20)
						give_item(ptd, name)
					}
				}
			}
			if (!HasLongJump[ptd]) {
				if (PackJump[pid]) {
					give_item(ptd, "item_longjump")
					HasLongJump[ptd] = true
					if (get_cvar_num("csdm_explain")) {
						client_print(ptd, print_chat, "[CSDM] 得到辅助推进器, 在移动中按下蹲和跳可以使用推进器!")
					}
				}
			}
			//Get rid of pack
			destroyPack(pid)
		}
	}
	      
	return PLUGIN_CONTINUE
}

public replenish(Item[])
{
	new id = Item[0]

	if (id) {
		EntId[id] = makeEnt(id)
		if (EntId[id]) {
			if (get_cvar_num("csdm_sounds")) {
				emit_sound(EntId[id], CHAN_ITEM, "items/suitchargeok1.wav", 0.85, ATTN_NORM, 0, 150)
			}
		} else {
			//failed to replenish, make a new one
			new Float:Time = get_cvar_float("csdm_item_time")
			set_task(Time, "replenish", 0, Item, 2)
		}
	}
}

bool:destroyPack(pid)
{
	//This function will remove a pack by ENTID and clear index space for it
	if (!pid) {
		return false
	}
	
	new entid = PackId[pid]
	
	destroyTask(PackTask[pid])
	
	PackId[pid] = 0
	PackTask[pid] = 0
	PackAmmo[pid][0] = 0
	PackAmmo[pid][1] = 0
	PackAmmo[pid][2] = 0
	PackAmmo[pid][3] = 0
	PackAmmo[pid][4] = 0
	PackAmmo[pid][5] = 0
	PackGren[pid][0] = 0
	PackGren[pid][1] = 0
	PackGren[pid][2] = 0
	PackJump[pid] = false
	
	safe_rm_ent(entid)
	
	return true
}

findNextTask()
{
	new i
	for (i=1; i<MAX_TASKS; i++) {
		if (!Tasks[i]) {
			Tasks[i] = random_num(400, 9000) + i
			return i
		}
	}
	
	destroyTask(1)
	Tasks[1] = random_num(400, 9000)
	
	return 1
}

findNextDrop()
{
	new i
	for (i=1; i<MAX_DROP; i++) {
		if (!DropId[i] && !DropTask[i]) {
			return i
		}
	}
	
	destroyDrop(1)
	
	return 1
}

createDrop(entid)
{
	if (!entid) {
		return 0
	}
	new id = findNextDrop()
	new taskid = findNextTask()
	new Float:Time = get_cvar_float("csdm_delete_time")
	new Drop[2]
	
	DropId[id] = entid
	DropTask[id] = taskid
	Drop[0] = id
	
	if (Time >= 5.0) {
		set_task(Time, "timed_rem_drop", Tasks[taskid], Drop, 2)
	}
	
	return id
}

findDrop(entid)
{
	new i
	for (i=1; i<MAX_DROP; i++) {
		if (DropId[i] == entid) {
			return i
		}
	}
	
	return 0
}

destroyTask(id)
{
	if (id && Tasks[id]) {
		remove_task(Tasks[id])
		Tasks[id] = 0
	}
	
	return id
}

destroyDrop(id)
{
	new entid = DropId[id]
	new taskid = DropTask[id]
	
	safe_rm_ent(entid)
	destroyTask(taskid)
	DropId[id] = 0
	
	return id
}

findNextZeroPack()
{
	//This function will search for an index to store pack data
	new ret
	new i
	
	for (i=1; i<MAX_DROP; i++) {
		if (!PackId[i]) {
			return i
		}
	}

	ret = destroyPack(1)
	
	return ret
}

createPack(id, Origin[3])
{
	new Float:Vec[3]
	new Float:Time = get_cvar_float("csdm_delete_time")
	new pid = findNextZeroPack()
	new i
	
	IVecFVec(Origin, Vec)
	
	//Create physical pack
	new entid = mkent()
	//Now, a pack is actually a tempent.
	if (entid) {
		PackId[pid] = entid
		entity_set_string(entid, EV_SZ_classname, "drop_pack")
		entity_set_model(entid, "models/w_weaponbox.mdl")
		entity_set_origin(entid, Vec)
		entity_set_int(entid, EV_INT_solid, 1)
		entity_set_int(entid, EV_INT_movetype, 6)
		//entity_set_edict(entid, EV_ENT_groundentity, 1)
		entity_set_edict(entid, EV_ENT_groundentity, entid)
		entity_set_edict(entid, EV_ENT_owner, id)
		new wps[32], num, type
		num = 0
		get_user_weapons(id, wps, num)
		for (i=0; i<num; i++) {
			//populate the pack
			type = getWepAmmoType(wps[i])
			new iType
			if (get_cvar_num("csdm_asskicr")) {
				iType=7
			}else{
				iType=5
			}
			if (type > 0 && type < iType) { 
				PackAmmo[pid][type-1] = wps[i]
			}
			if (type == iType) {
				if (wps[i] == CSW_HEGRENADE) {
					PackGren[pid][2] = CSW_HEGRENADE
				}
				if (wps[i] == CSW_SMOKEGRENADE) {
					PackGren[pid][1] = CSW_SMOKEGRENADE
				}
				if (wps[i] == CSW_FLASHBANG) {
					PackGren[pid][0] = CSW_FLASHBANG
				}
			}
		}
		if (HasLongJump[id]) {
			if (get_cvar_num("csdm_pack_jumps")) {
				PackJump[pid] = true
			} else {
				PackJump[pid] = false
			}
		} else {
			PackJump[pid] = false
		}
		if (Time > 30.0) {
			Time = 30.0
		}
		new Drop[2]
		Drop[0] = pid
		new taskid = findNextTask()
		PackTask[pid] = taskid
	
		set_task(Time, "delete_drop_pack", Tasks[taskid], Drop, 2)
	}
	
	return pid
}

public delete_drop_pack(data[])
{
	new pid = data[0]
	
	destroyPack(pid)

	return PLUGIN_CONTINUE
}

bool:canGetAmmo(id, ammo)
{
	new c, a
	switch (ammo) {
		case PISTOL_AMMO:
		{
			get_user_ammo(id, CSW_DEAGLE, c, a)
			if (a<getMaxAmmo(CSW_DEAGLE)) {
				return true
			}
			get_user_ammo(id, CSW_P228, c, a)
			if (a<getMaxAmmo(CSW_P228)) {
				return true
			}
			get_user_ammo(id, CSW_USP, c, a)
			if (a<getMaxAmmo(CSW_USP)) {
				return true
			}
			get_user_ammo(id, CSW_GLOCK18, c, a)
			if (a<getMaxAmmo(CSW_GLOCK18)) {
				return true
			}
			get_user_ammo(id, CSW_FIVESEVEN, c, a)
			if (a<getMaxAmmo(CSW_FIVESEVEN)) {
				return true
			}
		}
		
		case SHOTGUN_AMMO:
		{
			get_user_ammo(id, CSW_XM1014, c, a)
			if (a<getMaxAmmo(CSW_XM1014)) {
				return true
			}
		}
		
		case SMG_AMMO:
		{
			get_user_ammo(id, CSW_P90, c, a)
			if (a<getMaxAmmo(CSW_P90)) {
				return true
			}
			get_user_ammo(id, CSW_MP5NAVY, c, a)
			if (a<getMaxAmmo(CSW_MP5NAVY)) {
				return true
			}
			get_user_ammo(id, CSW_MAC10, c, a)
			if (a<getMaxAmmo(CSW_MAC10)) {
				return true
			}
		}
		
		case RIFLE_AMMO:
		{
			get_user_ammo(id, CSW_M4A1, c, a)
			if (a<getMaxAmmo(CSW_M4A1)) {
				return true
			}
			get_user_ammo(id, CSW_AK47, c, a)
			if (a<getMaxAmmo(CSW_AK47)) {
				return true
			}
			if (!get_cvar_num("csdm_asskicr")) {
				get_user_ammo(id, CSW_AWP, c, a)
				if (a<getMaxAmmo(CSW_AWP)) {
					return true
				}
				get_user_ammo(id, CSW_M249, c, a)
				if (a<getMaxAmmo(CSW_M249)) {
					return true
				}
			}
		}
		
		case AWP_AMMO:
		{
			if (get_cvar_num("csdm_asskicr")) {
				get_user_ammo(id, CSW_AWP, c, a)
				if (a<getMaxAmmo(CSW_AWP)) {
					return true
				}
			}
		}
		case PARA_AMMO:
		{
			if (get_cvar_num("csdm_asskicr")) {
				get_user_ammo(id, CSW_M249, c, a)
				if (a<getMaxAmmo(CSW_M249)) {
					return true
				}
			}
		}
	}
	
	return false
}

bool:isWpOverload(id, g_wp)
{
	new players[32], mPlayers
	new wps[32], wpc
	new pv, i, j, x=0
	new g_max = wp_max(g_wp)
	
	if (g_max < 1) {
		return false
	}
	if (get_cvar_num("csdm_add_items")) {
		get_players(players, mPlayers)
		for (i=0; i<mPlayers; i++) {
			pv = players[i]
			if (pv != id) {
				wpc = 0
				get_user_weapons(pv, wps, wpc)
				for (j=0; j<wpc; i++) {
					if (wps[j] == g_wp) {
						x++
						if (x == g_max) {
							return true
						}
					}
				}
			}
		}
	} else {
		get_players(players, mPlayers)
		for (i=0; i<mPlayers; i++) {
			pv = players[i]
			if (pv != id) {
				if (g_LastWep[pv][1] == g_wp) {
					x++
					if (x == g_max) {
						return true
					}
				}
			}
		}
	}
			
	return false
}

wp_max(g_wp)
{
	new i
	for (i=1; i<=Blocks; i++) {
		if (BlockedWps[i] == g_wp) {
			return RestrictWps[i]
		}
	}
	
	return 0
}

bool:canGetGun(id, g_wp)
{
	new g_slot = getWepSlot(g_wp)
	new wps[32], num, ammo, u_slot, u_max
	new clip
	new bool:has = false		//have this weapon?
	new bool:hold = true		//can hold more in slot?
	new i
	
	if (!g_wp || !id) {
		return false
	}
	
	if (isWpBlocked(g_wp) || isWpOverload(id, g_wp)) {
		return false
	}
	num = 0
	get_user_weapons(id, wps, num)
	
	for (i=0; i<num; i++) {		//does the user have this weapon?
		get_user_ammo(id, wps[i], ammo, clip)
		u_slot = getWepSlot(wps[i])
		if ((u_slot == g_slot) && (g_slot != 4)) {
			if (get_cvar_num("csdm_hold_many")!=1) {
				hold = false
			}
		}
		
		if (wps[i] == g_wp) {		//make sure user has this weapon
			u_max = getMaxAmmo(wps[i])
			if (clip < u_max) {
				return true
			}
			has = true
		}
	}
	
	if (!has) {	//Make sure this user does not have this weapon and has slot room
		if (hold) {
			return true
		} else {
			if (get_cvar_num("csdm_hold_many")) {
				return true
			}
			return false
		}
	} else {
		return false
	}
	
	return false
}

findPackId(entid)
{
	//Given an entity id, this will return the index to it in the pack list
	new id = 0
	new i
	
	if (!entid) {
		return 0
	}
	
	for (i=0; i<MAX_DROP; i++) {
		if (PackId[i] == entid) {
			id = i
		}
	}
	
	return id
}

findEntId(entid)
{
	//Given an entity id, this will return the index to it in the entity list
	new id = 0
	new i
	
	if (!entid) {
		return 0
	}
	
	for (i=1; i<EntCount; i++) {
		if (EntId[i] == entid) {
			id = i
		}
	}
	
	return id
}

getWepModel(wp, model[], imax)
{
	switch (wp) {
		case CSW_P228:
			copy(model, imax, "models/w_p228.mdl")
		case CSW_SCOUT:
			copy(model, imax, "models/w_scout.mdl")
		case CSW_HEGRENADE:
			copy(model, imax, "models/w_hegrenade.mdl")
		case CSW_XM1014:
			copy(model, imax, "models/w_xm1014.mdl")
		case CSW_C4:
			copy(model, imax, "models/w_backpack.mdl")
		case CSW_MAC10:
			copy(model, imax, "models/w_mac10.mdl")
		case CSW_AUG:
			copy(model, imax, "models/w_aug.mdl")
		case CSW_SMOKEGRENADE:
			copy(model, imax, "models/w_smokegrenade.mdl")
		case CSW_ELITE:
			copy(model, imax, "models/w_elite.mdl")
		case CSW_FIVESEVEN:
			copy(model, imax, "models/w_fiveseven.mdl")
		case CSW_UMP45:
			copy(model, imax, "models/w_ump45.mdl")
		case CSW_SG550:
			copy(model, imax, "models/w_sg550.mdl")
		case CSW_GALIL:
			copy(model, imax, "models/w_galil.mdl")
		case CSW_FAMAS:
			copy(model, imax, "models/w_famas.mdl")
		case CSW_USP:
			copy(model, imax, "models/w_usp.mdl")
		case CSW_GLOCK18:
			copy(model, imax, "models/w_glock18.mdl")
		case CSW_AWP:
			copy(model, imax, "models/w_awp.mdl")
		case CSW_MP5NAVY:
			copy(model, imax, "models/w_mp5.mdl")
		case CSW_M249:
			copy(model, imax, "models/w_m249.mdl")
		case CSW_M3:
			copy(model, imax, "models/w_m3.mdl")
		case CSW_M4A1:
			copy(model, imax, "models/w_m4a1.mdl")
		case CSW_TMP:
			copy(model, imax, "models/w_tmp.mdl")
		case CSW_G3SG1:
			copy(model, imax, "models/w_g3sg1.mdl")
		case CSW_FLASHBANG:
			copy(model, imax, "models/w_flashbang.mdl")
		case CSW_DEAGLE:
			copy(model, imax, "models/w_deagle.mdl")
		case CSW_SG552:
			copy(model, imax, "models/w_sg552.mdl")
		case CSW_AK47:
			copy(model, imax, "models/w_ak47.mdl")
		case CSW_KNIFE:
			copy(model, imax, "models/w_knife.mdl")
		case CSW_P90:
			copy(model, imax, "models/w_p90.mdl")
	}
	
	return 1
}

getCSDMWp(wp, model[], imax)
{
	switch (wp) {
		case CSW_P228:
			copy(model, imax, "csdmw_p228")
		case CSW_SCOUT:
			copy(model, imax, "csdmw_scout")
		case CSW_HEGRENADE:
			copy(model, imax, "csdmw_hegrenade")
		case CSW_XM1014:
			copy(model, imax, "csdmw_xm1014")
		case CSW_C4:
			copy(model, imax, "csdmw_c4")
		case CSW_MAC10:
			copy(model, imax, "csdmw_mac10")
		case CSW_AUG:
			copy(model, imax, "csdmw_aug")
		case CSW_SMOKEGRENADE:
			copy(model, imax, "csdmw_smokegrenade")
		case CSW_ELITE:
			copy(model, imax, "csdmw_elite")
		case CSW_FIVESEVEN:
			copy(model, imax, "csdmw_fiveseven")
		case CSW_UMP45:
			copy(model, imax, "csdmw_ump45")
		case CSW_SG550:
			copy(model, imax, "csdmw_sg550")
		case CSW_GALIL:
			copy(model, imax, "csdmw_galil")
		case CSW_FAMAS:
			copy(model, imax, "csdmw_famas")
		case CSW_USP:
			copy(model, imax, "csdmw_usp")
		case CSW_GLOCK18:
			copy(model, imax, "csdmw_glock18")
		case CSW_AWP:
			copy(model, imax, "csdmw_awp")
		case CSW_MP5NAVY:
			copy(model, imax, "csdmw_mp5navy")
		case CSW_M249:
			copy(model, imax, "csdmw_m249")
		case CSW_M3:
			copy(model, imax, "csdmw_m3")
		case CSW_M4A1:
			copy(model, imax, "csdmw_m4a1")
		case CSW_TMP:
			copy(model, imax, "csdmw_tmp")
		case CSW_G3SG1:
			copy(model, imax, "csdmw_g3sg1")
		case CSW_FLASHBANG:
			copy(model, imax, "csdmw_flashbang")
		case CSW_DEAGLE:
			copy(model, imax, "csdmw_deagle")
		case CSW_SG552:
			copy(model, imax, "csdmw_sg552")
		case CSW_AK47:
			copy(model, imax, "csdmw_ak47")
		case CSW_KNIFE:
			copy(model, imax, "csdmw_knife")
		case CSW_P90:
			copy(model, imax, "csdmw_p90")
	}
	
	return 1
}

get_wpname(wp, name[], imax)
{
	switch (wp) {
		case CSW_P228:
			copy(name, imax, "p228")
		case CSW_SCOUT:
			copy(name, imax, "scout")
		case CSW_HEGRENADE:
			copy(name, imax, "hegrenade")
		case CSW_XM1014:
			copy(name, imax, "xm1014")
		case CSW_C4:
			copy(name, imax, "c4")
		case CSW_MAC10:
			copy(name, imax, "mac10")
		case CSW_AUG:
			copy(name, imax, "aug")
		case CSW_SMOKEGRENADE:
			copy(name, imax, "smokegrenade")
		case CSW_ELITE:
			copy(name, imax, "elite")
		case CSW_FIVESEVEN:
			copy(name, imax, "fiveseven")
		case CSW_UMP45:
			copy(name, imax, "ump45")
		case CSW_SG550:
			copy(name, imax, "sg550")
		case CSW_GALIL:
			copy(name, imax, "galil")
		case CSW_FAMAS:
			copy(name, imax, "famas")
		case CSW_USP:
			copy(name, imax, "usp")
		case CSW_GLOCK18:
			copy(name, imax, "glock18")
		case CSW_AWP:
			copy(name, imax, "awp")
		case CSW_MP5NAVY:
			copy(name, imax, "mp5navy")
		case CSW_M249:
			copy(name, imax, "m249")
		case CSW_M3:
			copy(name, imax, "m3")
		case CSW_M4A1:
			copy(name, imax, "m4a1")
		case CSW_TMP:
			copy(name, imax, "tmp")
		case CSW_G3SG1:
			copy(name, imax, "g3sg1")
		case CSW_FLASHBANG:
			copy(name, imax, "flashbang")
		case CSW_DEAGLE:
			copy(name, imax, "deagle")
		case CSW_SG552:
			copy(name, imax, "sg552")
		case CSW_AK47:
			copy(name, imax, "ak47")
		case CSW_KNIFE:
			copy(name, imax, "knife")
		case CSW_P90:
			copy(name, imax, "p90")
	}
	
	return 1
}

getCSDMWpId(wp[])
{
	if (equali(wp, "csdmw_p228")) {
		return CSW_P228
	} else if (equali(wp, "csdmw_scout")) {
		return CSW_SCOUT
	} else if (equali(wp, "csdmw_hegrenade")) {
		return CSW_HEGRENADE
	} else if (equali(wp, "csdmw_xm1014")) {
		return CSW_XM1014
	} else if (equali(wp, "csdmw_c4")) {
		return CSW_C4
	} else if (equali(wp, "csdmw_mac10")) {
		return CSW_MAC10
	} else if (equali(wp, "csdmw_aug")) {
		return CSW_AUG
	} else if (equali(wp, "csdmw_smokegrenade")) {
		return CSW_SMOKEGRENADE
	} else if (equali(wp, "csdmw_elite")) {
		return CSW_ELITE
	} else if (equali(wp, "csdmw_fiveseven")) {
		return CSW_FIVESEVEN
	} else if (equali(wp, "csdmw_ump45")) {
		return CSW_UMP45
	} else if (equali(wp, "csdmw_sg550")) {
		return CSW_SG550
	} else if (equali(wp, "csdmw_galil")) {
		return CSW_GALIL
	} else if (equali(wp, "csdmw_famas")) {
		return CSW_FAMAS
	} else if (equali(wp, "csdmw_usp")) {
		return CSW_USP
	} else if (equali(wp, "csdmw_glock18")) {
		return CSW_GLOCK18
	} else if (equali(wp, "csdmw_awp")) {
		return CSW_AWP
	} else if (equali(wp, "csdmw_mp5navy")) {
		return CSW_MP5NAVY
	} else if (equali(wp, "csdmw_m249")) {
		return CSW_M249
	} else if (equali(wp, "csdmw_m3")) {
		return CSW_M3
	} else if (equali(wp, "csdmw_m4a1")) {
		return CSW_M4A1
	} else if (equali(wp, "csdmw_tmp")) {
		return CSW_TMP
	} else if (equali(wp, "csdmw_g3sg1")) {
		return CSW_G3SG1
	} else if (equali(wp, "csdmw_flashbang")) {
		return CSW_FLASHBANG
	} else if (equali(wp, "csdmw_deagle")) {
		return CSW_DEAGLE
	} else if (equali(wp, "csdmw_sg552")) {
		return CSW_SG552
	} else if (equali(wp, "csdmw_ak47")) {
		return CSW_AK47
	} else if (equali(wp, "csdmw_knife")) {
		return CSW_KNIFE
	} else if (equali(wp, "csdmw_p90")) {
		return CSW_P90
	}
	
	return 0
}

getWepId(wp[])
{
	if (equali(wp, "weapon_p228")) {
		return CSW_P228
	} else if (equali(wp, "weapon_scout")) {
		return CSW_SCOUT
	} else if (equali(wp, "weapon_hegrenade")) {
		return CSW_HEGRENADE
	} else if (equali(wp, "weapon_xm1014")) {
		return CSW_XM1014
	} else if (equali(wp, "weapon_c4")) {
		return CSW_C4
	} else if (equali(wp, "weapon_mac10")) {
		return CSW_MAC10
	} else if (equali(wp, "weapon_aug")) {
		return CSW_AUG
	} else if (equali(wp, "weapon_smokegrenade")) {
		return CSW_SMOKEGRENADE
	} else if (equali(wp, "weapon_elite")) {
		return CSW_ELITE
	} else if (equali(wp, "weapon_fiveseven")) {
		return CSW_FIVESEVEN
	} else if (equali(wp, "weapon_ump45")) {
		return CSW_UMP45
	} else if (equali(wp, "weapon_sg550")) {
		return CSW_SG550
	} else if (equali(wp, "weapon_galil")) {
		return CSW_GALIL
	} else if (equali(wp, "weapon_famas")) {
		return CSW_FAMAS
	} else if (equali(wp, "weapon_usp")) {
		return CSW_USP
	} else if (equali(wp, "weapon_glock18")) {
		return CSW_GLOCK18
	} else if (equali(wp, "weapon_awp")) {
		return CSW_AWP
	} else if (equali(wp, "weapon_mp5navy")) {
		return CSW_MP5NAVY
	} else if (equali(wp, "weapon_m249")) {
		return CSW_M249
	} else if (equali(wp, "weapon_m3")) {
		return CSW_M3
	} else if (equali(wp, "weapon_m4a1")) {
		return CSW_M4A1
	} else if (equali(wp, "weapon_tmp")) {
		return CSW_TMP
	} else if (equali(wp, "weapon_g3sg1")) {
		return CSW_G3SG1
	} else if (equali(wp, "weapon_flashbang")) {
		return CSW_FLASHBANG
	} else if (equali(wp, "weapon_deagle")) {
		return CSW_DEAGLE
	} else if (equali(wp, "weapon_sg552")) {
		return CSW_SG552
	} else if (equali(wp, "weapon_ak47")) {
		return CSW_AK47
	} else if (equali(wp, "weapon_knife")) {
		return CSW_KNIFE
	} else if (equali(wp, "weapon_p90")) {
		return CSW_P90
	}
	
	return 0
}

giveAmmoType(id, ammotype)
{
	switch (ammotype) {
		case PISTOL_AMMO:
		{
			give_item(id, "ammo_357sig")
			give_item(id, "ammo_57mm")
			give_item(id, "ammo_45acp")
			give_item(id, "ammo_50ae")
			give_item(id, "ammo_9mm")
		}
		case SHOTGUN_AMMO:
		{
			give_item(id, "ammo_buckshot")
		}
		case SMG_AMMO:
		{
			give_item(id, "ammo_9mm")
			give_item(id, "ammo_45acp")
		}
		case RIFLE_AMMO:
		{
			give_item(id, "ammo_762nato")
			give_item(id, "ammo_556nato")
			if (!get_cvar_num("csdm_asskicr")) {
				give_item(id, "ammo_338magnum")
				give_item(id, "ammo_556natobox")
			}
		}
		case AWP_AMMO:
		{
			if (get_cvar_num("csdm_asskicr")) {
				give_item(id, "ammo_338magnum")
			}
		}
		case PARA_AMMO:
		{
			if (get_cvar_num("csdm_asskicr")) {
				give_item(id, "ammo_556natobox")
			}
		}
	}
}

getWepAmmoType(wp)
{
	switch (wp)
	{
		case CSW_P228:
			return 1
		case CSW_SCOUT:
			return 4
		case CSW_HEGRENADE:
			if (get_cvar_num("csdm_asskicr")) {
				return 7
			} else {
				return 5
			}
		case CSW_XM1014:
			return 2
		case CSW_MAC10:
			return 3
		case CSW_AUG:
			return 4
		case CSW_SMOKEGRENADE:
			if (get_cvar_num("csdm_asskicr")) {
				return 7
			} else {
				return 5
			}
		case CSW_ELITE:
			return 1
		case CSW_FIVESEVEN:
			return 1
		case CSW_UMP45:
			return 3
		case CSW_SG550:
			return 4
		case CSW_GALIL:
			return 4
		case CSW_FAMAS:
			return 4
		case CSW_USP:
			return 1
		case CSW_GLOCK18:
			return 1
		case CSW_AWP:
			if (get_cvar_num("csdm_asskicr")) {
				return 5
			} else {
				return 4
			}
		case CSW_MP5NAVY:
			return 3
		case CSW_M249:
			if (get_cvar_num("csdm_asskicr")) {
				return 6
			} else {
				return 4
			}
		case CSW_M3:
			return 2
		case CSW_M4A1:
			return 4
		case CSW_TMP:
			return 3
		case CSW_G3SG1:
			return 4
		case CSW_FLASHBANG:
			if (get_cvar_num("csdm_asskicr")) {
				return 7
			} else {
				return 5
			}
		case CSW_DEAGLE:
			return 1
		case CSW_SG552:
			return 4
		case CSW_AK47:
			return 4
		case CSW_P90:
			return 3
	}
	
	return 0
}

getWepSlot(wp)
{
	switch (wp)
	{
		case CSW_P228:
			return 3
		case CSW_SCOUT:
			return 2
		case CSW_HEGRENADE:
			return 4
		case CSW_XM1014:
			return 2
		case CSW_C4:
			return 5
		case CSW_MAC10:
			return 2
		case CSW_AUG:
			return 2
		case CSW_SMOKEGRENADE:
			return 5
		case CSW_ELITE:
			return 3
		case CSW_FIVESEVEN:
			return 3
		case CSW_UMP45:
			return 2
		case CSW_SG550:
			return 2
		case CSW_GALIL:
			return 2
		case CSW_FAMAS:
			return 2
		case CSW_USP:
			return 3
		case CSW_GLOCK18:
			return 3
		case CSW_AWP:
			return 2
		case CSW_MP5NAVY:
			return 2
		case CSW_M249:
			return 2
		case CSW_M3:
			return 2
		case CSW_M4A1:
			return 2
		case CSW_TMP:
			return 2
		case CSW_G3SG1:
			return 2
		case CSW_FLASHBANG:
			return 4
		case CSW_DEAGLE:
			return 3
		case CSW_SG552:
			return 2
		case CSW_AK47:
			return 2
		case CSW_KNIFE:
			return 1
		case CSW_P90:
			return 2
	}
	
	return 0
}

bool:isValidDrop(wp)
{
	switch (wp)
	{
		case CSW_P228:
			return true
		case CSW_SCOUT:
			return true
		case CSW_HEGRENADE:
			return false
		case CSW_XM1014:
			return true
		case CSW_C4:
			return true
		case CSW_MAC10:
			return true
		case CSW_AUG:
			return true
		case CSW_SMOKEGRENADE:
			return false
		case CSW_ELITE:
			return true
		case CSW_FIVESEVEN:
			return true
		case CSW_UMP45:
			return true
		case CSW_SG550:
			return true
		case CSW_GALIL:
			return true
		case CSW_FAMAS:
			return true
		case CSW_USP:
			return true
		case CSW_GLOCK18:
			return true
		case CSW_AWP:
			return true
		case CSW_MP5NAVY:
			return true
		case CSW_M249:
			return true
		case CSW_M3:
			return true
		case CSW_M4A1:
			return true
		case CSW_TMP:
			return true
		case CSW_G3SG1:
			return true
		case CSW_FLASHBANG:
			return false
		case CSW_DEAGLE:
			return true
		case CSW_SG552:
			return true
		case CSW_AK47:
			return true
		case CSW_KNIFE:
			return false
		case CSW_P90:
			return true
	}
	
	return false
}

getMaxAmmo(wp)
{
	switch (wp)
	{
		case CSW_P228:
			return 52
		case CSW_SCOUT:
			return 90
		case CSW_HEGRENADE:
			return 1
		case CSW_XM1014:
			return 32
		case CSW_C4:
			return 1
		case CSW_MAC10:
			return 100
		case CSW_AUG:
			return 90
		case CSW_SMOKEGRENADE:
			return 1
		case CSW_ELITE:
			return 120
		case CSW_FIVESEVEN:
			return 100
		case CSW_UMP45:
			return 100
		case CSW_SG550:
			return 90
		case CSW_GALIL:
			return 90
		case CSW_FAMAS:
			return 90
		case CSW_USP:
			return 100
		case CSW_GLOCK18:
			return 120
		case CSW_AWP:
			return 30
		case CSW_MP5NAVY:
			return 120
		case CSW_M249:
			return 200
		case CSW_M3:
			return 32
		case CSW_M4A1:
			return 90
		case CSW_TMP:
			return 120
		case CSW_G3SG1:
			return 90
		case CSW_FLASHBANG:
			return 2
		case CSW_DEAGLE:
			return 35
		case CSW_SG552:
			return 90
		case CSW_AK47:
			return 90
		case CSW_KNIFE:
			return 1
		case CSW_P90:
			return 100
	}
	
	return 0
}

bool:isWpBlocked(wp)
{
	new wpn[24]
	new i
	get_wpname(wp, wpn, 24)
	for (i=1; i<=Blocks; i++) {
		if (BlockedWps[i] == wp) {
			return true
		}
	}
	
	return false
}

findNextSlot()
{
	new i
	for (i=1; i<MAX_ENTITIES; i++) {
		if (!EdictSlot[i]) {
			return i
		}
	}
	
	safe_rm_ent(EdictSlot[1])
	
	return 1
}

findSlot(entid)
{
	new i
	for (i=1; i<MAX_ENTITIES; i++) {
		if (EdictSlot[i] == entid) {
			return i
		}
	}
	
	return 0
}

//im not deleting this algorithm because it's cool =D
/*findSpawns(SP[])
{
	new T, CT, g
	new i
	
	for (i=1; i<=SPAWNS; i++) {
		if (SP[i] == 1) {
			T++
		} else if (SP[i] == 2) {
			CT++
		}
	}
	
	g = (random_num(3,18) % 2) + 1
	
	if (T > CT + 2) {
		g = 2
	}

	return g
}*/

mkent(ent[]="info_target")
{
	new entid, slot
	
	if ((entity_count() <= 1050) && (CurMaxEnt <= 1050)) {
		entid = create_entity(ent)
		Entities++
		slot = findNextSlot()
		EdictSlot[slot] = entid
	} else {
		return 0
	}

	return entid
}

rment(entid)
{
	new slot
	
	if (entid > 32 && is_valid_ent(entid)) {
		remove_entity(entid)
		slot = findSlot(entid)
		EdictSlot[slot] = 0
		Entities--
	}
	
	return entid
}

public cancel_vote(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_A)){
		client_print(id,print_console,"[CSDM] You do not have appropriate access.")
		return PLUGIN_HANDLED
	}
	if (!Voting) {
		return PLUGIN_HANDLED
	}
	CancelVote = true
	client_print(0, print_chat, "[CSDM] 投票被管理员取消.")
	return PLUGIN_HANDLED
}

public vote_freeforallsay(id)
{
	new name[32]

	get_user_name(id,name,31)
	new vflags[5]
	get_cvar_string("csdm_voteflags", vflags, 5)

	if (!get_cvar_num("csdm_voting") || !(cwrap(vflags, "c"))) {
		client_print(id,print_chat,"[CSDM] 服务器不允许举行对自由竞赛模式的投票.")
		return PLUGIN_HANDLED
	}
	if (!get_cvar_num("csdm_active")) {
		client_print(id, print_chat, "[CSDM] 死亡竞赛还没有被开启!")
		return PLUGIN_HANDLED
	}
	if (get_cvar_num("csdm_voting")==2) {
		if (!(get_user_flags(id)&ADMIN_LEVEL_A)) {
			client_print(id, print_console, "[CSDM] You do not have appropriate access.")
			return PLUGIN_CONTINUE
		}
	}
	if (get_cvar_num("csdm_voting")) {
		if(Voting) {
			client_print(id, print_chat, "[CSDM] 目前有一个投票正在进行中, 请稍候再举行投票.")
			return PLUGIN_CONTINUE
		}
		
		if (get_gametime() < lastVote) {
			client_print(id, print_chat, "[CSDM] 抱歉, 现在不允许举行投票, 请稍候再举行投票.")
			return PLUGIN_CONTINUE
		} else {
			client_print(0, print_chat, "[CSDM] %s 举行了对自由竞赛模式的投票.", name)
			dovote(id, 3)
			return PLUGIN_CONTINUE
		}
	}
    
	return PLUGIN_CONTINUE
}

public vote_freeforall(id)
{
	new name[32]

	get_user_name(id,name,31)
	new vflags[5]
	get_cvar_string("csdm_voteflags", vflags, 5)
	
	if (!get_cvar_num("csdm_voting") || !(cwrap(vflags, "c"))) {
		client_print(id,print_chat,"[CSDM] 服务器不允许举行对自由竞赛模式的投票.")
		return PLUGIN_HANDLED
	}
	if (!get_cvar_num("csdm_active")) {
		client_print(id, print_chat, "[CSDM] 死亡竞赛还没有被开启!")
		return PLUGIN_HANDLED
	}
	if (get_cvar_num("csdm_voting")==2) {
		if (!(get_user_flags(id)&ADMIN_LEVEL_A)) {
			client_print(id, print_console, "[CSDM] You do not have appropriate access.")
			return PLUGIN_HANDLED
		}
	}
	if (get_cvar_num("csdm_voting")) {
		if(Voting) {
			client_print(id, print_chat, "[CSDM] 目前有一个投票正在进行中, 请稍候再举行投票.")
			return PLUGIN_HANDLED
		}
		
		if (get_gametime() < lastVote) {
			client_print(id, print_chat, "[CSDM] 抱歉, 现在不允许举行投票, 请稍候再举行投票.")
			return PLUGIN_HANDLED
		} else {
			client_print(0, print_chat, "[CSDM] %s 举行了对自由竞赛模式的投票.", name)
			dovote(id, 3)
			return PLUGIN_HANDLED
		}
	}
    
	return PLUGIN_HANDLED
}

public vote_modesay(id)
{
	new name[32]

	get_user_name(id,name,31)
	new vflags[5]
	get_cvar_string("csdm_voteflags", vflags, 5)
	
	if (!get_cvar_num("csdm_voting") || !(cwrap(vflags, "b"))) {
		client_print(id,print_chat,"[CSDM] 服务器不允许举行对死亡竞赛模式的投票.")
		return PLUGIN_HANDLED
	}
	if (!get_cvar_num("csdm_active")) {
		client_print(id, print_chat, "[CSDM] 死亡竞赛还没有被开启!")
		return PLUGIN_HANDLED
	}
	if (get_cvar_num("csdm_voting")==2) {
		if (!(get_user_flags(id)&ADMIN_LEVEL_A)) {
			client_print(id, print_console, "[CSDM] You do not have appropriate access.")
			return PLUGIN_CONTINUE
		}
	}
	if (get_cvar_num("csdm_voting")) {
		if(Voting) {
			client_print(id, print_chat, "[CSDM] 目前有一个投票正在进行中, 请稍候再举行投票.")
			return PLUGIN_CONTINUE
		}
		
		if (get_gametime() < lastVote) {
			client_print(id, print_chat, "[CSDM] 抱歉, 现在不允许举行投票, 请稍候再举行投票.")
			return PLUGIN_CONTINUE
		} else {
			client_print(0, print_chat, "[CSDM] %s 举行了对死亡竞赛模式的投票.", name)
			dovote(id, 2)
			return PLUGIN_CONTINUE
		}
	}
    
	return PLUGIN_CONTINUE
}

public vote_mode(id)
{
	new name[32]

	get_user_name(id,name,31)
	new vflags[5]
	get_cvar_string("csdm_voteflags", vflags, 5)
	
	if (!get_cvar_num("csdm_voting") || !(cwrap(vflags, "b"))) {
		client_print(id,print_chat,"[CSDM] 服务器不允许举行对死亡竞赛模式的投票.")
		return PLUGIN_HANDLED
	}
	if (!get_cvar_num("csdm_active")) {
		client_print(id, print_chat, "[CSDM] 死亡竞赛还没有被开启!")
		return PLUGIN_HANDLED
	}
	if (get_cvar_num("csdm_voting")==2) {
		if (!(get_user_flags(id)&ADMIN_LEVEL_A)) {
			client_print(id, print_console, "[CSDM] You do not have appropriate access.")
			return PLUGIN_HANDLED
		}
	}
	if (get_cvar_num("csdm_voting")) {
		if(Voting) {
			client_print(id, print_chat, "[CSDM] 目前有一个投票正在进行中, 请稍候再举行投票.")
			return PLUGIN_HANDLED
		}
		
		if (get_gametime() < lastVote) {
			client_print(id, print_chat, "[CSDM] 抱歉, 现在不允许举行投票, 请稍候再举行投票.")
			return PLUGIN_HANDLED
		} else {
			client_print(0, print_chat, "[CSDM] %s 举行了对死亡竞赛模式的投票.", name)
			dovote(id, 2)
			return PLUGIN_HANDLED
		}
	}
    
	return PLUGIN_HANDLED
}

public csdm_votesay(id)
{
	new name[32]

	get_user_name(id,name,31)
	new vflags[5]
	get_cvar_string("csdm_voteflags", vflags, 5)
	
	if (!get_cvar_num("csdm_voting") || !(cwrap(vflags, "a"))) {
		client_print(id,print_chat,"[CSDM] 服务器不允许举行对死亡竞赛开关的投票.")
		return PLUGIN_HANDLED
	}
	if (get_cvar_num("csdm_voting")==2) {
		if (!(get_user_flags(id)&ADMIN_LEVEL_A)) {
			client_print(id, print_console, "[CSDM] You do not have appropriate access.")
			return PLUGIN_CONTINUE
		}
	}
	if (get_cvar_num("csdm_voting")) {
		if(Voting) {
			client_print(id, print_chat, "[CSDM] 目前有一个投票正在进行中, 请稍候再举行投票.")
			return PLUGIN_CONTINUE
		}
		
		if (get_gametime() < lastVote) {
			client_print(id, print_chat, "[CSDM] 抱歉, 现在不允许举行投票, 请稍候再举行投票.")
			return PLUGIN_CONTINUE
		} else {
			client_print(0, print_chat, "[CSDM] %s 举行了对死亡竞赛开关的投票.", name)
			dovote(id, 1)
			return PLUGIN_CONTINUE
		}
	}
    
	return PLUGIN_CONTINUE
}

public csdm_vote(id)
{
	new name[32]

	get_user_name(id,name,31)
	new vflags[5]
	get_cvar_string("csdm_voteflags", vflags, 5)
	
	if (!get_cvar_num("csdm_voting") || !(cwrap(vflags, "a"))) {
		client_print(id,print_chat,"[CSDM] 服务器不允许举行对死亡竞赛开关的投票.")
		return PLUGIN_HANDLED
	}
	if (get_cvar_num("csdm_voting")==2) {
		if (!(get_user_flags(id)&ADMIN_LEVEL_A)) {
			client_print(id, print_console, "[CSDM] You do not have appropriate access.")
			return PLUGIN_HANDLED
		}
	}
	if (get_cvar_num("csdm_voting")) {
		if(Voting) {
			client_print(id, print_chat, "[CSDM] 目前有一个投票正在进行中, 请稍候再举行投票.")
			return PLUGIN_HANDLED
		}
		
		if (get_gametime() < lastVote) {
			client_print(id, print_chat, "[CSDM] 抱歉, 现在不允许举行投票, 请稍候再举行投票.")
			return PLUGIN_HANDLED
		} else {
			client_print(0, print_chat, "[CSDM] %s 举行了对死亡竞赛开关的投票.", name)
			dovote(id, 1)
			return PLUGIN_HANDLED
		}
	}
    
	return PLUGIN_HANDLED
}

public vote_count(id,key)
{
	if(CancelVote) {
		return PLUGIN_HANDLED
	}
	
	if (!key) {
		Votes++
	}
	
	return PLUGIN_HANDLED
}

public votes_timer()
{
	lastVote = get_gametime() + get_cvar_float("csdm_nextvote")
	if(CancelVote) {
		client_print(0, print_chat, "[CSDM] 投票被取消.")
		CancelVote = false
		return PLUGIN_HANDLED
	}
	new players[32], mPlayers
	get_players(players, mPlayers, "c")
	new Float:voteRatio = get_cvar_float("csdm_ratio")
	new Float:results = mPlayers ? (float(Votes) / float(mPlayers)) : 0.0
	new n = VoteFor
	if (n==1) {
		if (results>=voteRatio) {
			if (!get_cvar_num("csdm_active")) {
				client_print(0, print_chat, "[CSDM] 投票结果: 死亡竞赛将被开启.")
				log_amx("[CSDM] CSDM Mode turned on.")
				client_print(0, print_console, "[CSDM] There may be some lag as the map is prepared.")
				set_cvar_num("csdm_active", 1)
				set_task(1.0, "start_map")
			} else {
				client_print(0, print_chat, "[CSDM] 投票结果: 死亡竞赛保持开启状态.")
			}
		} else {
			if (get_cvar_num("csdm_active")) {
				client_print(0, print_chat, "[CSDM] 投票结果: 死亡竞赛被关闭.")
				log_amx("[CSDM] CSDM Mode turned off.")
				set_cvar_num("csdm_active", 0)
				destroyAllItems()
				restoreSpawns()
				restoreHostages()
				server_cmd("sv_restartround 2")
			} else {
				client_print(0, print_chat, "[CSDM] 投票结果: 死亡竞赛保持关闭状态.")
			}
		}
	} else if (n==2) {
		if (results>=voteRatio) {
			if (get_cvar_num("csdm_add_items")) {
				client_print(0, print_chat, "[CSDM] 投票结束! 转为选枪模式.")
				destroyAllItems()
				set_cvar_num("csdm_add_items", 0)
				log_amx("[CSDM] Switching to menu mode.")
			} else {
				client_print(0, print_chat, "[CSDM] 投票结束! 保持选枪模式.")
			}
		} else {
			if (get_cvar_num("csdm_add_items")) {
				client_print(0, print_chat, "[CSDM] 投票结束! 保持捡枪模式.")
			} else {
				client_print(0, print_chat, "[CSDM] 投票结束! 转为选枪模式.")
				log_amx("[CSDM] Switching to item mode.")
				set_cvar_num("csdm_add_items", 1)
				set_cvar_num("csdm_allow_clguns", 0)
				setEnts()
			}
		}
	} else if (n==3) {
		if (results>=voteRatio) {
			if (get_cvar_num("csdm_kill_all")) {
				client_print(0, print_chat, "[CSDM] 投票结束! 保持自由竞赛模式开启状态.")
			} else {
				client_print(0, print_chat, "[CSDM] 投票结束! 开启自由竞赛模式. 现在起每个人都是你的敌人!")
				set_cvar_num("csdm_kill_all", 1)
				set_cvar_num("mp_autokick", 0)
				set_cvar_num("mp_tkpunish", 0)
				set_cvar_num("mp_autoteambalance", 0)
				set_cvar_num("mp_friendlyfire", 1)
				log_amx("[CSDM] Enabling free-for-all.")
			}
		} else {
			if (get_cvar_num("csdm_kill_all")) {
				client_print(0, print_chat, "[CSDM] 投票结束! 关闭自由竞赛模式.")
				log_amx("[CSDM] Disabling free-for-all.")
				set_cvar_num("csdm_kill_all", 0)
				set_cvar_num("mp_friendlyfire", 0)
			} else {
				client_print(0, print_chat, "[CSDM] 投票结束! 保持自由竞赛模式关闭状态.")
			}
		}
	}
	VoteFor = 0
	Voting = false

	return PLUGIN_HANDLED
}

public dovote(id, n)
{
	Votes = 0
	Voting = true
	new menu[256]
	//there was a little toolshed where he made us suffer
	if (n==1) {
		format(menu, 255, "\yCSDM: 死亡竞赛开关\w^n^n1. 开启^n2. 关闭")
	} else if (n==2) {
		format(menu, 255, "\yCSDM: 模式选择\w^n^n1. 选枪模式^n2. 捡枪模式")
	} else if (n==3) {
		format(menu, 255, "\yCSDM: 自由竞赛开关\w^n^n1. 开启^n2. 关闭")
	} else {
		client_print(id, print_chat, "[CSDM] 无效的投票.")
	}
	VoteFor = n
	show_menu(0, (1<<0)|(1<<1), menu, floatround(get_cvar_float("csdm_votetime")))
	new Float:Time = get_cvar_float("csdm_votetime")
	set_task(Time, "votes_timer")
	
	return PLUGIN_CONTINUE
}

safe_rm_ent(id)
{
	new class[32]
	
	if (is_valid_ent(id)) {
	
		entity_get_string(id, EV_SZ_classname, class, 32)
		if (cwrap(class,"csdm")||cwrap(class,"view")||cwrap(class,"drop")||cwrap(class,"ammo")||cwrap(class,"armor")) {
			rment(id)
			return 1
		}
	}
		
	return 0
}