 /* AMX Mod script.
*
* This file is provided as is (no warranties).
*
* This plugin contains:
* o multikill announcement
* o bomb events
* o killing streak
* o enemy remaining
* o round counter
* o italy bonus kill
* o knife kill
* o headshot kill
* o greanade kill
* o last man
* o double kill
* o player name
* o first blood sound
*
* To use with AMX 0.9.6 (and higher) and Counter-Strike.
* Stats can be enabled with amx_statscfg and amx_statscfgmenu commands.
* NOTE: For pernament disable, comment file from plugins.ini
* or use amx_pausecfg and amx_pausecfgmenu commands.
* Rest of stats can be found in csstats plugin.
*/

#include <amxmod>

public MultiKill
public MultiKillSound
public BombPlanting
public BombDefusing
public BombPlanted
public BombDefused
public BombFailed
public BombPickUp
public BombDrop
public BombCountVoice
public BombCountDef
public BombReached
public ItalyBonusKill
public EnemyRemaining
public LastMan
public KnifeKill
public KnifeKillSound
public GrenadeKill
public GrenadeSuicide
public HeadShotKill
public HeadShotKillSound
public RoundCounterSound
public RoundCounter
public KillingStreak
public KillingStreakSound
public DoubleKill
public DoubleKillSound
public PlayerName
public FirstBloodSound
public KnifeKillReward
public KillSeries
public KillSeriesReward
public BombReward

new g_streakKills[33][2]
new g_multiKills[33][2]
new g_Planter
new g_Defuser
new g_C4Timer
new g_Defusing
new Float:g_LastOmg
new Float:g_LastPlan
new g_LastAnnounce
new g_roundCount
new Float:g_doubleKill
new g_doubleKillId
new g_friend[33]
new g_firstBlood
new g_killnum[33]
new g_killtime[33]
new g_tempkilltime[33]
new g_killreward[33]
new g_bombreward = 300

new g_MultiKillMsg[7][] = {
  "干的好! %s^n杀人数 %d 个 (爆头数 %d 个)",
  "%s 真能杀!!^n杀人数 %d 个 (爆头数 %d 个)",
  "%s 简直是狂战士!!!^n杀人数 %d 个 (爆头数 %d 个)",
  "%s 已经是杀人王了^n杀人数 %d 个 (爆头数 %d 个)",
  "%s 势不可挡!^n杀人数 %d 个 (爆头数 %d 个)",
  "莫非 %s 就是魔王!!^n杀人数 %d 个 (爆头数 %d 个)",
  "%s 如同上帝一样永生!!!!^n杀人数 %d 个 (爆头数 %d 个)"
}
new g_Sounds[7][] = {
  "multikill",
  "ultrakill",
  "killingspree",
  "rampage",
  "unstoppable",
  "monsterkill",
  "godlike"
}
new g_KillingMsg[7][] = {
  "%s: 干的好!",
  "%s: 真能杀!!!",
  "%s 简直是狂战士!!!",
  "%s: 是杀人王!!!",
  "%s 势不可挡!!!",
  "%s 就像魔王!",
  "%s 如同上帝!!!"
}
new g_KinfeMsg[4][] = {
  "%s 悄然无息的干掉了 %s",
  "%s 拔出刀剖开了 %s",
  "%s 谨慎的跟在 %s 后用刀暗杀了他",
  "%s 用刀剁了 %s"
}
new g_LastMessages[4][] = {
  "^n现在全看你的了!",
  "^n上帝与你同在!孩子",
  "^n你的队友全部牺牲了,祝你好运!",
  "^n你现在孤身一人了,多加小心!"
}
new g_HeMessages[4][] = {
  "%s 送给 %s 了会爆炸的礼物--手雷",
  "%s 用手雷把 %s 送上了天",
  "%s 精确的把手雷投向了 %s",
  "%s 给 %s 制造了个大爆炸"
}
new g_SHeMessages[4][] = {
  "%s 好奇的拉保险后炸到了自己",
  "%s 感受了手雷的威力",
  "%s 把手雷扔进了自己的裤裆",
  "%s 送自己去见上帝了!"
}
new g_HeadShots[7][] = {
  "$kn 用漂亮的一枪命中了 $vn 的头部!",
  "$kn 用 $wn 把 $vn 的头从身体上了分了家",
  "$kn 在 $vn 的头上用 $wn 开了个洞",
  "$vn 被 $kn 以闪电般的速度击倒",
  "$vn 的头被 $kn 变成了红色的胶状物",
  "$kn 自信的掏出了 $wn,随着枪声 $vn 倒在地上.",
  "$vn 的头是在是太大了,$kn 随便开枪都...."
}

new g_teamsNames[2][] = {
  "TERRORIST",
  "CT"
}

public plugin_init(){
  register_plugin("Misc. Stats","1.0","default, dudu improve it")
  register_event("DeathMsg","eDeathMsg","a")
  register_event("TextMsg","eRestart","a","2&#Game_C","2&#Game_w")
  register_event("SendAudio", "eEndRound", "a", "2&%!MRAD_terwin","2&%!MRAD_ctwin","2&%!MRAD_rounddraw")
  register_event("RoundTime", "eNewRound", "bc")
  register_event("StatusValue","setTeam","be","1=1")
  register_event("StatusValue","showStatus","be","1=2","2!0")
  register_event("StatusValue","hideStatus","be","1=1","2=0")
  new mapname[32]
  get_mapname(mapname,31)
  if (equali(mapname,"de_",3)||equali(mapname,"csde_",5)){
    register_event("StatusIcon", "eGotBomb", "be", "1=1", "1=2", "2=c4")
    register_event("SendAudio", "eBombPlanted", "a", "2&%!MRAD_BOMBPL")
    register_event("SendAudio", "eBombDef", "a", "2&%!MRAD_BOMBDEF")
    register_event("TextMsg", "eBombFail", "a", "2&#Target_B")
    register_event("BarTime", "eBombDefG", "be", "1=10", "1=5","1=3")
    register_event("BarTime", "eBombDefL", "be", "1=0")
    register_event("TextMsg", "eBombPickUp", "bc", "2&#Got_bomb")
    register_event("TextMsg", "eBombDrop", "bc", "2&#Game_bomb_d")
  }
  else if ( equali( mapname ,  "cs_italy"  ) ) {
    register_event( "23" , "chickenKill", "a" , "1=108" , /*"12=106",*/ "15=4" )
    register_event( "23" , "radioKill", "a" , "1=108" , /*"12=294",*/ "15=2" )
  }
}

public plugin_cfg(){
  new g_addStast[] = "amx_statscfg add ^"%s^" %s"
  server_cmd(g_addStast,"杀人等级","MultiKill")
  server_cmd(g_addStast,"杀人等级音效","MultiKillSound")
  server_cmd(g_addStast,"C4埋放过程","BombPlanting")
  server_cmd(g_addStast,"C4拆解过程","BombDefusing")
  server_cmd(g_addStast,"C4被放置","BombPlanted")
  server_cmd(g_addStast,"C4被成功拆解","BombDefused")
  server_cmd(g_addStast,"C4拆解失败","BombFailed")
  server_cmd(g_addStast,"拿到C4","BombPickUp")
  server_cmd(g_addStast,"C4掉落","BombDrop")
  server_cmd(g_addStast,"C4倒计时","BombCountVoice")
  server_cmd(g_addStast,"C4倒计时(拆解时)","BombCountDef")
  server_cmd(g_addStast,"到达埋雷点","BombReached")
  server_cmd(g_addStast,"C4事件奖励","BombReward")
  server_cmd(g_addStast,"Italy其他事件","ItalyBonusKill")
  server_cmd(g_addStast,"最后一人","LastMan")
  server_cmd(g_addStast,"用刀杀死","KnifeKill")
  server_cmd(g_addStast,"用刀杀死音效","KnifeKillSound")
  server_cmd(g_addStast,"用刀杀死奖励","KnifeKillReward")
  server_cmd(g_addStast,"手雷杀死","GrenadeKill")
  server_cmd(g_addStast,"用手雷自杀","GrenadeSuicide")
  server_cmd(g_addStast,"爆头","HeadShotKill")
  server_cmd(g_addStast,"爆头音效","HeadShotKillSound")
  server_cmd(g_addStast,"局数显示","RoundCounter")
  server_cmd(g_addStast,"局数显示音效","RoundCounterSound")
  server_cmd(g_addStast,"杀人技能","KillingStreak")
  server_cmd(g_addStast,"杀人技能音效","KillingStreakSound")
  server_cmd(g_addStast,"敌人剩余","EnemyRemaining")
  server_cmd(g_addStast,"双杀","DoubleKill")
  server_cmd(g_addStast,"双杀音效","DoubleKillSound")
  server_cmd(g_addStast,"连续杀人","KillSeries")
  server_cmd(g_addStast,"连续杀人奖励","KillSeriesReward")
  server_cmd(g_addStast,"玩家名字","PlayerName")
  server_cmd(g_addStast,"第一个杀人","FirstBloodSound")
}

public client_putinserver(id)
  g_multiKills[id] = g_streakKills[ id ] = { 0 , 0 }


public eDeathMsg(){
  new killerId = read_data(1)
  if ( killerId == 0 ) return
  new victimId = read_data(2)
  new bool:enemykill = (get_user_team(killerId) != get_user_team(victimId))
  new headshot = read_data(3)
  if ( g_firstBlood ) {
  	g_firstBlood = 0
  	if ( FirstBloodSound ) client_cmd(0,"spk misc/firstblood")
  }
  if ( (KillingStreak || KillingStreakSound) && enemykill ) {
    g_streakKills[ killerId ][ 0 ]++
    g_streakKills[ killerId ][ 1 ] = 0
    g_streakKills[ victimId ][ 1 ]++
    g_streakKills[ victimId ][ 0 ] = 0
    new a = g_streakKills[ killerId ][ 0 ] - 3
    if ( (a > -1) && !( a % 2 ) ) {
      new name[32]
      get_user_name( killerId , name , 31 )
      if ( (a >>= 1) > 6 ) a = 6
      if ( KillingStreak ){
        set_hudmessage(0, 100, 255, 0.05, 0.55, 2, 0.02, 6.0, 0.01, 0.1, 3)
        show_hudmessage(0,g_KillingMsg[ a ], name )
      }
      if (  KillingStreakSound )  client_cmd( 0 ,  "spk misc/%s" , g_Sounds[ a ] )
    }
  }
  if ( MultiKill || MultiKillSound ) {
    if (killerId && enemykill ) {
      g_multiKills[killerId][0]++
      g_multiKills[killerId][1] += headshot
      new param[2]
      param[0] = killerId
      param[1] = g_multiKills[killerId][0]
      set_task( 4.0 + float( param[1] ) ,"checkKills",0,param,2)
    }
  }
  if ( EnemyRemaining ) {
    new ppl[32], pplnum
    new team = get_user_team( victimId ) - 1
    get_players(ppl,pplnum,"e", g_teamsNames[1 - team] )
    if (pplnum){
      new eppl[32], epplnum
      get_players(eppl,epplnum,"ae",g_teamsNames[team])
      if (epplnum) {
        new message[128]
        format(message,127,"%d %s 个剩余",epplnum,(team==0)?"匪徒":"警察" )
        set_hudmessage(255,255,255,0.02,0.85,2, 0.05, 0.1, 0.02, 3.0, 3)
        for(new a=0; a<pplnum; ++a) show_hudmessage(ppl[a],message)
        //client_print(ppl[a],print_chat,message)
      }
    }
  }
  if ( LastMan ) {
    new cts[32], ts[32], ctsnum, tsnum
    get_players(cts,ctsnum,"ae", g_teamsNames[1] )
    get_players(ts,tsnum,"ae", g_teamsNames[0] )
    if ( ctsnum == 1 && tsnum == 1 ){
        new ctname[32], tname[32]
        get_user_name(cts[0],ctname,31)
        get_user_name(ts[0],tname,31)
        set_hudmessage(0, 255, 255, -1.0, 0.35, 0, 6.0, 6.0, 0.5, 0.15, 3)
        show_hudmessage(0,"%s 单挑 %s",ctname,tname)
        client_cmd(0,"spk misc/maytheforce")
    }
    else if ( !g_LastAnnounce  ) {
      new oposite = 0, team = 0
      if ( ctsnum == 1 && tsnum > 1 ) {
        g_LastAnnounce = cts[0]
        oposite = tsnum
        team = 0
      }
      else if ( tsnum == 1 && ctsnum > 1 ) {
        g_LastAnnounce = ts[0]
        oposite = ctsnum
        team = 1
      }
      if (g_LastAnnounce){
        new name[32]
        get_user_name(g_LastAnnounce,name,31)
        set_hudmessage(0, 255, 255, -1.0, 0.35, 0, 6.0, 6.0, 0.5, 0.15, 3)
        show_hudmessage(0,"%s (%d 血) 对决 %d %s%s",name,
        get_user_health(g_LastAnnounce),oposite,
        (team==0)?"匪徒":"警察",g_LastMessages[ random_num(0,3) ] )
        client_cmd(g_LastAnnounce,"spk misc/oneandonly")
      }
    }
  }
  new arg[4]
  read_data( 4 , arg , 3  )
  if ( equal( arg, "kni" ) && ( KnifeKill || KnifeKillSound || KnifeKillReward )  )  {
    if ( KnifeKill ) {
      new killer[32], victim[32]
      get_user_name(killerId,killer,31)
      get_user_name(victimId,victim,31)
      set_hudmessage(255, 100, 100, -1.0, 0.25, 1, 6.0, 6.0, 0.5, 0.15, 1)
      show_hudmessage(0,g_KinfeMsg[ random_num(0,3) ],killer,victim)
    }
    if ( KnifeKillSound ) client_cmd(0,"spk misc/humiliation")
    if ( KnifeKillReward && enemykill ){
    	new x = random_num(2000, 5000)
    	set_user_money(killerId,x+get_user_money(killerId))
    	announceEvent2(killerId,x,"%s 在用刀杀人中奖励 $%d")
    }
  }
  else if ( equal( arg, "gre" ) && (GrenadeKill || GrenadeSuicide)  )  {
    new killer[32], victim[32]
    get_user_name(killerId,killer,32)
    get_user_name(victimId,victim,32)
    set_hudmessage(255, 100, 100, -1.0, 0.25, 1, 6.0, 6.0, 0.5, 0.15, 1)
    if ( killerId != victimId ){
      if ( GrenadeKill ) show_hudmessage(0,g_HeMessages[ random_num(0,3)],killer,victim)
    }
    else if ( GrenadeSuicide ) show_hudmessage(0,g_SHeMessages[ random_num(0,3) ],victim)
  }
  if ( headshot && (HeadShotKill || HeadShotKillSound) )  {
    if ( HeadShotKill ){
      new killer[32], victim[32], weapon[32], message[128]
      get_user_name(killerId,killer,31)
      get_user_name(victimId,victim,31)
      read_data( 4 , weapon , 31  )
      copy( message, 127, g_HeadShots[ random_num(0,6) ] )
      replace( message, 127 , "$vn", victim )
      replace( message, 127 , "$wn", weapon )
      replace( message, 127 , "$kn", killer )
      set_hudmessage(100, 100, 255, -1.0, 0.29, 0, 6.0, 6.0, 0.5, 0.15, 1)
      show_hudmessage(0,message )
    }
    if ( HeadShotKillSound ) {
    	client_cmd(killerId,"spk misc/headshot")
    	client_cmd(victimId,"spk misc/headshot")
   	}
  }
  if ( DoubleKill || DoubleKillSound ) {
    new Float:nowtime = get_gametime()
    if ( g_doubleKill == nowtime && g_doubleKillId == killerId ) {
      if ( DoubleKill ) {
        new name[32]
        get_user_name( killerId , name , 31  )
        set_hudmessage(255, 0, 255, -1.0, 0.35, 0, 6.0, 6.0, 0.5, 0.15, 3)
        show_hudmessage(0,"哇! %s 打出了双杀" ,name )
      }
      if ( DoubleKillSound ) client_cmd(0,"spk misc/doublekill")
    }
    g_doubleKill = nowtime
    g_doubleKillId = killerId
  }
  if ( KillSeries && enemykill ){
  	new killsm[32][3],killss[32][3],killnm[32],killns[32],temp1,temp2
  	get_time("%M", killsm[killerId], 2)
  	killnm[killerId] = strtonum(killsm[killerId])
  	get_time("%S", killss[killerId], 2)
  	killns[killerId] = strtonum(killss[killerId])
  	g_killtime[killerId] = 60 * killnm[killerId] + killns[killerId]
  	if ( g_killnum[killerId] == 0 )
  		g_tempkilltime[killerId] = g_killtime[killerId]
   	++g_killnum[killerId]
  	temp1 = g_killtime[killerId] - g_tempkilltime[killerId]
  	temp2 = 2 * g_killnum[killerId] - 1
  	if (  g_killnum[killerId] > 1 ){
  		if ( temp1 <= temp2 ){
  			new name[32]
        		get_user_name( killerId , name , 31  )
        		set_hudmessage( 150, 144, 50, 0.03, 0.85, 0, 6.0, 10.0, 0.1, 0.2, 5)
        		if ( KillSeriesReward ){
        			new tempmoney = 1000 * (g_killnum[killerId] -1)
        			g_killreward[killerId] += tempmoney
  				show_hudmessage(0,"%s 在 %d 秒里连杀了 %d 个敌人.^n并将在本局结束时得到奖励 $%d",name,temp2,g_killnum[killerId],g_killreward[killerId] )
  			}else{
				show_hudmessage(0,"%s 在 %d 秒里连杀了 %d 个敌人.",name,temp2,g_killnum[killerId])
  			}
  		}else{
  		g_killnum[killerId] = 1
  		g_tempkilltime[killerId] = g_killtime[killerId]
  		}
  	}
  }
}

public hideStatus(id)
  if ( PlayerName ){
    set_hudmessage(0,0,0,0.0,0.0,0, 0.0, 0.01, 0.0, 0.0, 4)
    show_hudmessage(id,"")
  }

public setTeam(id)
  g_friend[id] = read_data(2)

public showStatus(id)
  if ( PlayerName ){
    new name[32],pid = read_data(2)
    get_user_name(pid,name,31)
    new color1 = 0,color2 = 0
    if ( get_user_team(pid)==1 )
      color1 = 255
    else
      color2 = 255
    if (g_friend[id]==1){ // friend
      new clip, ammo, wpnid = get_user_weapon(pid,clip,ammo)
      new wpnname[32]
      get_weaponname(wpnid,wpnname,31)
      set_hudmessage(color1,50,color2,-1.0,0.60,1, 0.01, 3.0, 0.01, 0.01, 4)
      show_hudmessage(id,"%s -- %d 血 / %d 甲 / %s",name,
        get_user_health(pid),get_user_armor(pid),wpnname[7])
    }
    else {
      set_hudmessage(color1,50,color2,-1.0,0.60,1, 0.01, 3.0, 0.01, 0.01, 4)
      show_hudmessage(id,name)
    }
  }

public eNewRound(){
  if ( read_data(1) == floatround(get_cvar_float("mp_roundtime") * 60.0) ) {
    g_firstBlood = 1
    g_C4Timer = 0
    ++g_roundCount
    if ( RoundCounter ) {
      set_hudmessage(200, 0, 0, -1.0, 0.30, 0, 6.0, 6.0, 0.5, 0.15, 1)
      show_hudmessage(0,  "准备战斗!^n第 %d 局" ,  g_roundCount )
    }
    if ( RoundCounterSound )  client_cmd( 0 , "spk misc/prepare" )
    if ( KillingStreak  ) {
      new appl[32],ppl, i
      get_players(appl,ppl, "ac" )
      for(new a = 0; a < ppl; ++a) {
        i = appl[ a ]
        if ( g_streakKills[ i ][ 0 ] >= 2 )
          client_print( i , print_chat , "* 你共杀了 %d 个而没有死亡过", g_streakKills[ i ][ 0 ] )
        else if (  g_streakKills[ i ][ 1 ] >= 2 )
          client_print( i , print_chat , "* 小心! 你已经死了 %d 次而没有杀过人了", g_streakKills[ i ][ 1 ] )
      }
    }
  }
  if ( KillSeries ){
    for (new i=0; i<33; ++i){
    g_killnum[i] = 0
    if (KillSeriesReward ) g_killreward[i] = 0
    }
  }
}

public eRestart(){
  eEndRound()
  g_roundCount = 0
  g_firstBlood = 1
}

public eEndRound(){
  if ( KillSeries && KillSeriesReward ){
    for (new x=0; x<33; ++x){
    if ( g_killreward[x] ) set_user_money(x, get_user_money(x)+g_killreward[x])
    }
  }
  g_C4Timer = -2
  g_LastPlan = 0.0
  g_LastOmg = 0.0
  g_LastPlan = 0.0
  remove_task(8038)
  g_LastAnnounce = 0
}

public checkKills(param[]){
  new id = param[0]
  new a = param[1]
  if (a == g_multiKills[id][0]){
    a -= 3
    if ( a > -1 ){
      if ( MultiKill ) {
        new name[32]
        get_user_name(id,name,31)
        set_hudmessage(255, 0, 100, 0.05, 0.65, 2, 0.02, 6.0, 0.01, 0.1, 2)
        if ( a > 6 ) a = 6
        show_hudmessage(0,g_MultiKillMsg[a],name,g_multiKills[id][0],g_multiKills[id][1])
      }
      if ( MultiKillSound ) client_cmd(0,"spk misc/%s",g_Sounds[a])
    }
    g_multiKills[id] = { 0,0 }
  }
}

public chickenKill()
  if ( ItalyBonusKill ) announceEvent( 0 , "有人杀了小鸡!!!"  )

public radioKill()
  if ( ItalyBonusKill ) announceEvent( 0 , "有人调大了收音机!!!" )

announceEvent( id , message[] ){
  new name[32]
  get_user_name(id, name , 31)
  set_hudmessage(255, 100, 50, -1.0, 0.30, 0, 6.0, 6.0, 0.5, 0.15, 1)
  show_hudmessage(0,message,name)
}

announceEvent2( id , num, message[] ){
  new name[32]
  get_user_name(id, name , 31)
  set_hudmessage( 85, 62, 210, 0.03, 0.85, 0, 6.0, 10.0, 0.1, 0.2, 5)
  show_hudmessage(0,message,name,num)
}

public eGotBomb(id){
  g_Planter = id
  g_Defuser = g_Defusing = 0
  if ( BombReached && read_data(1)==2 && g_LastOmg<get_gametime()){
    g_LastOmg = get_gametime() + 15.0
    announceEvent(g_Planter ,   "天啊! %s 到达了埋雷点!" )
  }
}

public eBombDefG(id){
  if (read_data(1) == 3){
    if ( BombPlanting && g_LastPlan<get_gametime() ){
      g_LastPlan = get_gametime() + 15.0
      announceEvent(g_Planter ,   "%s 正在放置C4!" )
    }
  }
  else {
    g_Defuser = g_Defusing = id
    if ( BombDefusing && g_LastPlan<get_gametime()){
      g_LastPlan = get_gametime() + 15.0
      announceEvent(g_Defusing ,   "%s 正在拆解C4" )
    }
  }
}

public eBombDefL(id)
  g_Defusing = 0

public eBombPlanted(){
  if (BombReward){
    announceEvent2(g_Planter,g_bombreward,"%s 成功放置C4奖励 $%d")
    set_user_money(g_Planter,get_user_money(g_Planter)+g_bombreward)
  }
  if ( g_C4Timer != -2 ){
    if (BombPlanted) announceEvent(g_Planter ,   "%s 把C4放置好了!!!" )
    g_C4Timer = get_cvar_num("mp_c4timer") - 2
    set_task(1.0,"bombTimer",8038,"",0,"b")
    g_LastPlan = 0.0
  }
}

public bombTimer(){
  if (--g_C4Timer > 0){
    if (BombCountVoice) {
      if (g_C4Timer == 30 || g_C4Timer == 20){
        new temp[48]
        num_to_word(g_C4Timer,temp,47)
        client_cmd(0,"spk ^"vox/%s seconds until explosion^"",temp)
      }
      else if (g_C4Timer < 11){
        new temp[48]
        num_to_word(g_C4Timer,temp,47)
        client_cmd(0,"spk ^"vox/%s^"",temp)
      }
    }
    if (BombCountDef && g_Defusing) client_print(g_Defusing,print_center,"%d",g_C4Timer)
  }
  else remove_task(8038)
}

public eBombDef(){
  if (BombReward){
    announceEvent2(g_Defuser,g_bombreward,"%s 拆C4成功奖励 $%d")
    set_user_money(g_Defuser,get_user_money(g_Defuser)+g_bombreward)
  }
  if (BombDefused) announceEvent(g_Defuser ,   "%s 成功拆除了C4!" )
}

public eBombFail()
  if (BombFailed && g_Defuser ) announceEvent(g_Defuser ,  "%s 拆解C4失败了" )

public eBombPickUp(id)
  if (BombPickUp) announceEvent(id , "%s 拾起了C4包")

public eBombDrop()
  if (BombDrop) announceEvent(g_Planter , "%s 掉了C4包!!!")
