/* AMX Mod X 
* 
* (c) Copyright 2004, datang 
* 
* This file is part of AMX Mod X. 
* 
*/ 

#include <amxmodx>
#include <amxmisc>

new g_menuPosition[33]

#define MENUS_NUMBER 8

new g_menuBody[MENUS_NUMBER][] = {
  "ADMIN_MENU",
  "THE_TIME",
  "TIME_LEFT",
  "NEXT_MAP",

  "SAY_RANKSTATS",
  "SAY_STATSME",

  "SAY_STATS",
  "SAY_TOP15"

  // Next Page

}

new g_menuCmd[MENUS_NUMBER][] = {
  "amxmodmenu",
  "say thetime",
  "say timeleft",
  "say nextmap",

  "say /rankstats",
  "say /statsme",

  "say /stats",
  "say /top15"

  // Next Page

}

new g_coloredMenus

public plugin_init() {
  register_plugin("saymenu","1.0","datang")

  register_dictionary("saymenu.txt")
  register_dictionary("common.txt")

  register_menucmd(register_menuid("USER MENU"),1023,"actionMenu")
  register_clcmd("say menu", "saymenu",0,"- displays user menu")

  g_coloredMenus = colored_menus()
}

public actionMenu(id,key) {
  switch (key) {
    case 8: displayMenu(id,++g_menuPosition[id])
    case 9: displayMenu(id,--g_menuPosition[id])
    default: client_cmd(id, g_menuCmd[ g_menuPosition[id] * 8 + key ] )
  }
  return PLUGIN_HANDLED
}

displayMenu(id,pos) {
  if (pos < 0)  return
    
  new menuBody[512]
  new b = 0
  new start = pos * 8
  
  if ( start >= MENUS_NUMBER )
    start = pos = g_menuPosition[id] = 0
      
  new len = format(menuBody,511, g_coloredMenus ? "\yUSER MENU\R%d/%d^n\w^n" : "USER MENU %d/%d^n^n" , pos+1, 2 )
    
  new end = start + 8
  new keys = MENU_KEY_0
  
  if (end > MENUS_NUMBER )
    end = MENUS_NUMBER
    
  for (new a = start; a < end; ++a) {
      keys |= (1<<b)
      len += format(menuBody[len],511-len,"%d. %L^n",++b, id, g_menuBody[ a ] )
  }
      
  if (end != MENUS_NUMBER ) {
    format(menuBody[len],511-len,"^n9. %L...^n0. %L", id, "MORE", id, pos ? "BACK" : "EXIT")
    keys |= MENU_KEY_9
  }
  else format(menuBody[len],511-len,"^n0. %L", id, pos ? "BACK" : "EXIT")
 
  show_menu(id,keys,menuBody)
}

public saymenu(id,level,cid) {

  displayMenu(id,g_menuPosition[id] = 0)

  return PLUGIN_HANDLED
}