/* AMX Mod X 
* 
* (c) Copyright 2004, datang 
* 
* This file is part of AMX Mod X. 
* 
*/ 

/* COMMANDS 

   Client: 
      say "time" in chat (wo quotes) 
   Server: 
      "time" in console (wo quotes) 
      cvar - amx_time_speak - 2	   is default. 0 = Time is displayed, 1 = Time w/beep, 2 = Time w/beep and Speech 
      cvar - amx_time_interval - 1 is default. 0 = Every Hour, 1 = Half Hour, 2 = 15 Minutes 
      cvar - amx_time_offset - 0   is default. Can set negative or positive the number of hours to offset time by. 
*/ 

#include <amxmodx> 

new CENTER_TIME_COLOR[3] = {255,100,0}

new MONTHS[12][] = {"1","2","3","4","5","6","7","8","9","10","11","12"} 

new Float:Time_Interval = 180.0 // Interval client "say time" command can be used in seconds. 

new cant_time[33] 

public SpeakTime(id) 
{ 
   if(id){ 
      if(cant_time[id]){ 
         client_print(id, print_chat,"* %L",LANG_SERVER,"TIME_60", Time_Interval/60.0) 
         return PLUGIN_HANDLED 
      } 
   } 
   cant_time[id] = 1 
   new a_id[1] 
   a_id[0] = id 
   set_task(Time_Interval,"remove_cant_time",0, a_id,1) 

   new w_Hour[11], w_Minutes1[11], w_Minutes2[11], am_pm[3] 
   new ns_Hour[3], ns_Minutes[3],ns_Month[3],ns_Day[3],ns_Year[5] 

   get_time("%H",ns_Hour, 2) 
   get_time("%M", ns_Minutes, 2) 
   get_time("%m", ns_Month, 2) 
   get_time("%d", ns_Day, 2) 
   get_time("%Y", ns_Year, 4) 

   new num_Hour = str_to_num(ns_Hour) + get_cvar_num("amx_time_offset") 
   if(num_Hour > 11){ 
      num_Hour -= 12 
      copy(am_pm,2,"pm") 
   } 
   else 
      copy(am_pm,2,"am") 

   if(!num_Hour)
      num_Hour = 12

   num_to_word(num_Hour,w_Hour,10) 
        
   if(ns_Minutes[0] == '1'){ 
      num_to_word(str_to_num(ns_Minutes),w_Minutes1,10) 
   } 
   else{ 
      if(ns_Minutes[0] == '0'){ 
         if(ns_Minutes[1] != '0') 
            copy(w_Minutes1,10,"boop") 
      } 
      else{ 
         new PH[] = "00" 
         PH[0] = ns_Minutes[0] 
         num_to_word(str_to_num(PH),w_Minutes1,10) 
      } 

      if(ns_Minutes[1] != '0'){ 
         num_to_word(str_to_num(ns_Minutes[1]),w_Minutes2,10) 
      } 
   } 

   new mode = get_cvar_num("amx_time_speak") 
   if (mode == 2) 
      client_cmd(id,"speak ^"fvox/bell time_is_now %s %s %s _comma %s^"", w_Hour, w_Minutes1, w_Minutes2, am_pm) 
   else if(mode == 1) 
      client_cmd(id,"speak fvox/bell") 
    
   strtoupper(am_pm)
   client_print(id, print_chat, "%L", LANG_SERVER,"DATE", ns_Year, MONTHS[str_to_num(ns_Month) - 1],  ns_Day)
   client_print(id, print_chat, "%L", LANG_SERVER,"TIME", num_Hour, ns_Minutes,am_pm)

   set_hudmessage(CENTER_TIME_COLOR[0], CENTER_TIME_COLOR[1], CENTER_TIME_COLOR[2], -1.0, 0.30, 0, 0.5, 6.0 , 2.0, 2.0, 1) 
   show_hudmessage(id,"%L", LANG_SERVER,"DATE_TIME",num_Hour,ns_Minutes,am_pm, ns_Year, MONTHS[str_to_num(ns_Month) - 1], ns_Day)

   if(!id){ 
      server_print("[ %s-%s-%s ]", ns_Year, MONTHS[str_to_num(ns_Month) - 1], ns_Day)
      server_print("[ Current Server Time: %d:%s %s ]", num_Hour, ns_Minutes,am_pm)  
   } 

   return PLUGIN_HANDLED 
} 

public chime_check() 
{ 
   new s_Minutes[3], s_Seconds[3] 

   get_time("%M", s_Minutes, 2) 
   get_time("%S", s_Seconds, 2) 

   new num_Minutes = str_to_num(s_Minutes) 
   new num_Seconds = str_to_num(s_Seconds) 

   new Float:exec_time 

   if(num_Seconds > 30) 
      exec_time = 30.0 
   else 
      exec_time = 60.0 
    
   exec_time += float(get_exec_time(num_Minutes)) 

   set_task(exec_time, "exec_time_chime",1014)     
} 


public remove_cant_time(a_id[]) 
{ 
   cant_time[a_id[0]] = 0 
} 


public exec_time_chime() 
{ 
   SpeakTime(0) 

   new s_Minutes[3], s_Seconds[3] 

   get_time("%M", s_Minutes, 2) 
   get_time("%S", s_Seconds, 2) 

   new num_Minutes = str_to_num(s_Minutes) 
   new num_Seconds = str_to_num(s_Seconds) 

   new Float:exec_time 

   if(num_Seconds > 30) 
      exec_time = 30.0 
   else 
      exec_time = 60.0 

   exec_time += float(get_exec_time(num_Minutes)) 

   set_task(exec_time, "exec_time_chime",1015) 

} 

public get_exec_time(num_Minutes) 
{ 
   new time_1 
   new interval = get_cvar_num("amx_time_interval") 

   if(interval == 0){ 
      time_1 = (59 - num_Minutes) * 60 
   } 
   else if(interval == 2){ 
      if(num_Minutes < 15){ 
         time_1 = (14 - num_Minutes) * 60 
      } 
      else if(num_Minutes < 30){ 
         time_1 = (29 - num_Minutes) * 60 
      } 
      else if(num_Minutes < 45){ 
         time_1 = (44 - num_Minutes) * 60 
      } 
      else{ 
         time_1 = (59 - num_Minutes) * 60 
      } 
   } 
   else{ 
      if(num_Minutes < 30) 
         time_1 = (29 - num_Minutes) * 60 
      else 
         time_1 = (59 - num_Minutes) * 60 
   } 
    
   return time_1 
} 

public plugin_init() 
{ 
   register_plugin("Server Chime Plugin", "1.0", "datang") 
   register_dictionary("server_chime_plugin.txt")
   register_cvar("amx_time_speak","2") 
   register_cvar("amx_time_interval", "1") 
   register_cvar("amx_time_offset","0") 
   register_srvcmd("time","SpeakTime") 
   register_clcmd("say time","SpeakTime") 

   set_task(15.0,"chime_check",1013) 

   return PLUGIN_CONTINUE 
} 