/* AMXX Mod script.
* (c) 2004, xmdxtremekiller (Amxmodx Version)
* (c) 2003, T(+)rget
* This file is provided as is (no warranties).
*
* Admin Commands:
* amx_chicken - authid, nick, #userid, @1/2/3 (1 = Terrorists, 2 = Counter-Terrorists, 3 = VIP) or * (all)
* amx_unchicken - same format as above
* amx_chicken_sfx - turns off & on Chicken Special Effects, Sound & Transforming (CVAR)
* say /chickenmenu - enables the ChickenMod Menu System
*
* Client Commands:
* say /chickenme - turns yourself into a Chicken (Only available if ChickenSelf = ON)
* say /unchickenme - turns yourself into a Human (Only available if ChickenSelf = ON)
*
* (3.7.03) & previous
*---------
* Rebuilt from scratch AMX Mod Chicken v1.0.5.1 (Build #1)
* 4 Menu's built. (Main Menu + Player Menu + Team Menu + Settings Menu) // Optimised 
* Removed alot of coding. (Not Needed anymore due to above) 
* Made chicken.inc. (Don't Touch File Basically) 
* Optimised Team Coding. 
* Added on join chicken. (Like I did for AdminMod) // Optimised 
* Languages added: English, French & German. // Fixed 
* Added cvar for Chicken SFX. 
* Added access level to config. (Read about Access Levels) 
* Changed flagging system. 
* Unlocked + values for the Menu, so you don't have to stick to default. 
* Changed Naming System, customisable. (Try beating the system now ) 
* Changed cvar switching, hooks/gels better now with ChickenMod. 
* Added BOT support, blocks a few things. 
*
* (4.7.03)
*---------
* Fixed Menu Access bug (Wasn't implemented)
* Removed rest of Chicken Commands (amx_chicken & amx_unchicken)
*
* (5.7.03)
*---------
* Added Shawn's better Francais Translation.
* Fixed possible menu problems with other MOD's
* Fixed display in players menu, you cannot chicken/unchicken dead players
* Added message system back in
* Added sound system back in
*
* (1.8.03)
*---------
* Added a couple more settings to support amx_language 
* Removed Language Menu, not needed anymore since SniperBeamer & I have got in developement amx_language 
* Fixed Translations, thanks to Shawn (French) & SniperBeamer (German) 
* Added Menu Update System, captures commands/users & updates menu when required 
* Added plugin_end code, so everyone who is chicken gets unchicken 
* Added ResetHUD event, for better chicken support if someone swaps teams 
* Fixed naming problem, when everyone/team chickening
* Added VIP support 100%, other maps/mods don't see option 
* Fixed Update System, now working 100% flawlessly
* Added set_user_hitzones code, have to aim @ chicken now
* Fixed hitzone problem when a new round occurs
* Updated Multi-Language, 100% supports amx_language
* Added support for multi-leveled access commands
* 
* (19.8.03)
*----------
* Added, Multi-Mod support to force weapon knife
* Fixed, Multi-Levelled Access
* Fixed, Display for Settings Menu (Doesn't show if you haven't got access)
* Changed, Some code for AMX Mod v0.9.5b
* Changed, Message System so its all @ the top of the SMA instead of in a seperate file
* Added, Chicken Vision to config + menu
*
* (8.10.03)
* --------
* Added FOV detection, for better reset if client is a Chicken
* Updated Menu again, better support (Fixed Update System)
* Fixed keys, can't push nothing that doesn't appear in Menu
* Added amx_chicken & amx_unchicken
*
* (23.3.04)
*Added Amxmodx compatible
*/

#include <chicken>
//----------------------------------------------------------------------------------------------
/* MENU LANGUGAGES */
new ex[3][] = {
"退出",
"Sortie",
"Schliessen"
}

new bk[3][] = {
"返回",
"Revenir",
"Zurueck"
}

new mo[3][] = {
"下一页",
"Plus",
"Mehr"
}

new on[3][] = {
"开",
"MARCHE",
"AN"
}

new off[3][] = {
"关",
"ARRET",
"AUS"
}

new yes[3][] = {
"鸡",
"OUI",
"JA"
}

new no[3][] = {
"人",
"NON",
"NEIN"
}

new ck[3][] = {
"小鸡",
"POULET",
"HUHN"
}

new dd[3][] = {
"已死亡",
"MORT",
"TOT"
}

new hm[3][] = {
"人",
"HUMAIN",
"MENSCH"
}

new mh0[3][] = {
"主菜单",
"Menu Principal",
"Haupt Menu"
}

new mh1[3][] = {
"玩家菜单",
"Transformer des joueurs en poulets",
"Spieler Menu"
}

new mh2[3][] = {
"队伍菜单",
"Transformer une equipe en poulets",
"Team Menu"
}

new mh3[3][] = {
"设置菜单",
"Options",
"Einstellungs Menu"
}

new m63[3][] = {
"所有人",
"Tous",
"Jeder"
}

new m71[3][] = {
"小鸡炸弹",
"Les Poulets posent la bombe",
"Huehner Bomben"
}

new m72[3][] = {
"小鸡手雷",
"Les Poulets utilisent les grenades",
"Huehner Granaten"
}

new m73[3][] = {
"小鸡发光",
"Les Poulets brilles",
"Huehner Gluehen"
}

new m74[3][] = {
"低生命保护",
"Protection de la vie",
"Gesundheits Schutz"
}

new m75[3][] = {
"小鸡名字",
"Nom des Poulets",
"Huehner Namen"
}

new m76[3][] = {
"自变小鸡",
"Capacites de s'auto-transformer",
"Sich in ein Huhn verwandeln"
}

new m77[3][] = {
"小鸡交谈",
"Les Poulets parlent",
"Huehner Sprechen"
}

new m81[3][] = {
"小鸡队伍交谈",
"Les Poulets parlent en equipe",
"Huehner Team-Sprechen"
}

new m82[3][] = {
"不能成为小鸡",
"Vie minimum pour devenir un poulet",
"Nicht Erlaubtes Huhn"
}

new m83[3][] = {
"小鸡生命值",
"Vie Du Poulet",
"Huehner Gesundheit"
}

new m84[3][] = {
"小鸡重力值",
"Gravite Du Poulet",
"Huehner Schwerkraft"
}

new m85[3][] = {
"小鸡速度值",
"Vitesse Du Poulet",
"Huehner Geschwindigkeit"
}

new m86[3][] = {
"小鸡视野值",
"Vitesse Du Poulet",
"Huehner Geschwindigkeit"
}

new m87[3][] = {
"声音特效",
"Effets Speciaux De Poulet",
"Huehner Spezielle Effekte"
}
//----------------------------------------------------------------------------------------------
/* MESSAGE LANGUAGES */
new mg1[3][] = {
"你已经死亡, 不能恢复人型",
"Vous ne pouvez pas redevenir un humain, vous etes mort",
"Du kannst nicht zurueck in einen Menschen umgewandelt werden, du bist tot"
}

new mg2[3][] = {
"%s 让自己恢复了人型",
"%s est redevenu un humain",
"%s hat sich wieder in einen Menschen umgewandelt"
}

new mg3[3][] = {
"你的生命值过低, 不能成为小鸡",
"Vous n'avez pas assez de vie pour vous transformer en poulet",
"Du kannst dich nicht in ein Huhn verwandeln, deine Gesundheit ist zu niedrig"
}

new mg4[3][] = {
"你已经死亡, 不能成为小鸡",
"Vous ne pouvez pas vous transfomer en poulet, vous etes mort",
"Du kannst dich nicht in ein Huhn verwandeln, du bist tot"
}

new mg5[3][] = {
"%s 把自己变成了小鸡", 
"%s c'est transformer en poulet", 
"%s hat sich in ein Huhn umgewandelt"
}

new mg6[3][] = {
"%s 被恢复了人型",
"%s est redevenu un humain",
"%s ist wieder in einen Menschen umgewandelt worden"
}

new mg7[3][] = {
"%s 被变成了小鸡",
"%s a ete transforme en poulet",
"%s ist in ein Huhn umgewandelt worden"
}

new mg8[3][] = {
"%s 变成了小鸡",
"%s se sont transformes en poulets",
"%s sind in Huhner umgewandelt worden"
}

new mg9[3][] = {
"%s 恢复了人型",
"%s sont redevenus humains",
"%s sind wieder in Menschen umgewandelt worden"
}

new mg10[3][] = {
"所有人变成了小鸡",
"Tout le monde a ete transforme en poulets",
"Jeder ist in ein Huhn umgewandelt worden"
}

new mg11[3][] = {
"所有人恢复了人型",
"Tous le monde est redevenu humains",
"Jeder ist wieder in einen Menschen umgewandelt worden"
}
//----------------------------------------------------------------------------------------------
/* ACCESS LEVELS */
new ACCESS_MENU
new ACCESS_SETTINGS

/* MENU FLAGS */
new MenuFlags[33]
new MenuPFlags[33]
new g_menuPlayers[33][32]
new g_menuPlayersNum[33]
new MenuGrv = 5
new MenuHP = 50
new MenuSpd = 40

/* CONFIG SETUP */
new Team1[30]
new Team2[30]
new Team3
new bool:ChickenTeam1 = false
new bool:ChickenTeam2 = false
new bool:ChickenTeam3 = false
new bool:ChickenAll = false
new bool:HealthProtect = true
new bool:ChickenTalk = true
new bool:ChickenTeamTalk = true
new bool:ChickenSelf = true
new ChickenHP = 35

new bool:cstrike_is_running
//----------------------------------------------------------------------------------------------
public amx_chicken(id, level, cid)
{
	if(!cmd_access(id, level, cid, 2))
		return PLUGIN_HANDLED

	new arg[32]
	read_argv(1, arg, 31)
	
	if(arg[0] == '@')
	{
		new users[32], inum, team = str_to_num (arg[1])
		get_players(users, inum, "a")
		
		if(team == 1 && ChickenTeam1 == false)
		{
			ChickenTeam1 = true
			for(new i = 0; i < inum; ++i)
			{
				if(get_user_team(users[i]) == 1)
					chicken_user(users[i])

				set_hudmessage(255, 25, 255, 0.05, 0.65, 2, 0.1, 4.0, 0.02, 0.02, 10)
				show_hudmessage(users[i], mg8[lang[users[i]]], Team1)
			}
			if(get_cvar_num("amx_chicken_sfx"))
				chicken_sound(0)
			
			return PLUGIN_HANDLED
		}
		else if(team == 1 && ChickenTeam1)
			client_print(id, 1, "%s 已经是鸡了", Team1)
		
		else if(team == 2 && ChickenTeam2 == false)
		{
			ChickenTeam2 = true
			for(new i = 0; i < inum; ++i)
			{
				if(get_user_team(users[i]) == 2)
					chicken_user(users[i])
				
				set_hudmessage(255, 25, 255, 0.05, 0.65, 2, 0.1, 4.0, 0.02, 0.02, 10)
				show_hudmessage(users[i], mg8[lang[users[i]]], Team2)
			}
			if(get_cvar_num("amx_chicken_sfx"))
				chicken_sound(0)
			
			return PLUGIN_HANDLED
		}
		else if(team == 2 && ChickenTeam2)
			client_print(id, 1, "%s 已经是鸡了", Team2)
		
		else if(team == 3 && cstrike_is_running && ChickenTeam3 == false)
		{
			new map[32]
			get_mapname(map, 31)

			if(!contain(map, "as_"))
			{
				ChickenTeam3 = true
				chicken_user(Team3)
				
				if(get_cvar_num("amx_chicken_sfx"))
					emit_sound(Team3, CHAN_ITEM, "misc/chicken0.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
			}
			return PLUGIN_HANDLED
		}
		else if(team == 3 && cstrike_is_running && ChickenTeam3)
			client_print(id, 1, "VIP 已经是鸡了")
		
		else
			client_print(id, 1, cstrike_is_running ? "Usage: amx_chicken @1/2/3 (1 = %s, 2 = %s, 3 = VIP)" : "Usage: amx_chicken @1/2 (1 = %s, 2 = %s)", Team1, Team2)

		return PLUGIN_HANDLED
	}
	else if(arg[0] == '*')
	{ 
		new all[32], inum 
		get_players(all, inum, "a") 
		
		if(ChickenAll == false)
		{
			ChickenAll = true
			for(new i = 0; i < inum; ++i)
			{
				chicken_user(all[i])
				set_hudmessage(255, 25, 255, 0.05, 0.65, 2, 0.1, 4.0, 0.02, 0.02, 10)
				show_hudmessage(all[i], mg10[lang[all[i]]])
			}
			if(get_cvar_num("amx_chicken_sfx"))
				chicken_sound(0)
		}
		else
			client_print(id, 1, "所有人已经是小鸡了")

		return PLUGIN_HANDLED
	}
	else
	{ 
		new user[32], player = cmd_target(id, arg, 5)
		get_user_name(player, user, 31) 
		
		if(!player)
			return PLUGIN_HANDLED 
		
		if(UserFlags[player] == false)
		{
			new users[32], inum
			get_players(users, inum, "c")
			
			chicken_user(player) 
			
			set_hudmessage(255, 25, 255, 0.05, 0.65, 2, 0.1, 4.0, 0.02, 0.02, 10)

			if(get_cvar_num("amx_chicken_sfx"))
				emit_sound(player, CHAN_ITEM, "misc/chicken0.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
					
			for(new i = 0; i < inum; ++i)
				show_hudmessage(users[i], mg7[lang[users[i]]], user)
		}
		else
			client_print(id, 1, "* %s 已经是小鸡了", user)
	}
	return PLUGIN_HANDLED
}
//----------------------------------------------------------------------------------------------
public amx_unchicken(id, level, cid)
{
	if(!cmd_access(id, level, cid, 2))
		return PLUGIN_HANDLED

	new arg[32]
	read_argv(1, arg, 31)
	
	if(arg[0] == '@')
	{
		new users[32], inum, team = str_to_num (arg[1])
		get_players(users, inum, "a")
		
		if(team == 1 && ChickenTeam1)
		{
			ChickenTeam1 = false
			for(new i = 0; i < inum; ++i)
			{
				if(get_user_team(users[i]) == 1)
					unchicken_user(users[i])

				set_hudmessage(255, 25, 255, 0.05, 0.65, 2, 0.1, 4.0, 0.02, 0.02, 10)
				show_hudmessage(users[i], mg9[lang[users[i]]], Team1)
			}
			if(get_cvar_num("amx_chicken_sfx"))
				chicken_sound(5)
			
			return PLUGIN_HANDLED
		}
		else if(team == 1 && ChickenTeam1 == false)
			client_print(id, 1, "%s 已经恢复人型了", Team1)
		
		else if(team == 2 && ChickenTeam2)
		{
			ChickenTeam2 = false
			for(new i = 0; i < inum; ++i)
			{
				if(get_user_team(users[i]) == 2)
					unchicken_user(users[i])
				
				set_hudmessage(255, 25, 255, 0.05, 0.65, 2, 0.1, 4.0, 0.02, 0.02, 10)
				show_hudmessage(users[i], mg9[lang[users[i]]], Team2)
			}
			if(get_cvar_num("amx_chicken_sfx"))
				chicken_sound(5)
			
			return PLUGIN_HANDLED
		}
		else if(team == 2 && ChickenTeam2 == false)
			client_print(id, 1, "%s 已经恢复人型了", Team2)
		
		else if(team == 3 && cstrike_is_running && ChickenTeam3)
		{
			new map[32]
			get_mapname(map, 31)

			if(!contain(map, "as_"))
			{
				ChickenTeam3 = false
				unchicken_user(Team3)
				
				if(get_cvar_num("amx_chicken_sfx"))
					emit_sound(Team3, CHAN_ITEM, "misc/cow.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
			}
			return PLUGIN_HANDLED
		}
		else if(team == 3 && cstrike_is_running && ChickenTeam3 == false)
			client_print(id, 1, "VIP 已经恢复人型了")
		
		else
			client_print(id, 1, cstrike_is_running ? "Usage: amx_unchicken @1/2/3 (1 = %s, 2 = %s, 3 = VIP)" : "Usage: amx_unchicken @1/2 (1 = %s, 2 = %s)", Team1, Team2)

		return PLUGIN_HANDLED
	}
	else if(arg[0] == '*')
	{ 
		new all[32], inum 
		get_players(all, inum, "a") 
		
		if(ChickenAll == true)
		{
			ChickenAll = false
			for(new i = 0; i < inum; ++i)
			{
				unchicken_user(all[i])
				set_hudmessage(255, 25, 255, 0.05, 0.65, 2, 0.1, 4.0, 0.02, 0.02, 10)
				show_hudmessage(all[i], mg11[lang[all[i]]])
			}
			if(get_cvar_num("amx_chicken_sfx"))
				chicken_sound(5)
		}
		else
			client_print(id, 1, "所有人已经恢复人型了")

		return PLUGIN_HANDLED
	}
	else
	{ 
		new user[32], player = cmd_target(id, arg, 5)
		get_user_name(player, user, 31) 
		
		if(!player)
			return PLUGIN_HANDLED 
		
		if(UserFlags[player])
		{
			new users[32], inum
			get_players(users, inum, "c")
			
			unchicken_user(player) 
			
			set_hudmessage(255, 25, 255, 0.05, 0.65, 2, 0.1, 4.0, 0.02, 0.02, 10)

			if(get_cvar_num("amx_chicken_sfx"))
				emit_sound(player, CHAN_ITEM, "misc/cow.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
					
			for(new i = 0; i < inum; ++i)
				show_hudmessage(users[i], mg6[lang[users[i]]], user)
		}
		else
			client_print(id, 1, "* %s 已经恢复人型了", user)
	}
	return PLUGIN_HANDLED
}
//----------------------------------------------------------------------------------------------
/* SAY COMMAND CODE */
public chickensay(id)
{
	if(is_user_bot(id))
		return PLUGIN_CONTINUE
	
	new Text[192] 
	read_args(Text, 191) 
	remove_quotes(Text)

	if(UserFlags[id])
	{ 
		if(ChickenSelf) 
		{
			if(!containi(Text, "/unchickenme"))
			{
				if(!is_user_alive(id))
					client_print(id, 3, "[ChickenMod] - %s", mg1[lang[id]])
				
				else
				{
					unchicken_user(id)
					emit_sound(id, CHAN_ITEM, "misc/cow.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
					set_hudmessage(255, 25, 255, 0.05, 0.65, 2, 0.1, 4.0, 0.02, 0.02, 10)
					
					new users[32], inum
					get_players(users, inum, "c")
					
					for(new i = 0; i < inum; ++i)
						show_hudmessage(users[i], mg2[lang[users[i]]], UserOldName[id])
					
					user_kill(id, 1)
				}
				return PLUGIN_HANDLED
			}
		}
		if(ChickenTalk && is_user_alive(id) && !is_user_bot(id))
		{
			saying_match(id)
			return PLUGIN_HANDLED
		}
	}
	else if(!containi(Text, "/chickenme"))
	{
		if(ChickenSelf)
		{
			if(get_user_health(id) <= ChickenHP)
			{
				client_print(id, 3, "[小鸡插件] - %s", mg3[lang[id]])
				return PLUGIN_HANDLED
			}
			if(!is_user_alive(id))
			{
				client_print(id, 3, "[小鸡插件] - %s", mg4[lang[id]])
				return PLUGIN_HANDLED
			}
			else
			{
				chicken_user(id)
				emit_sound(id, CHAN_ITEM, "misc/chicken0.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
				set_hudmessage(255, 25, 255, 0.05, 0.65, 2, 0.1, 4.0, 0.02, 0.02, 10)
				
				new user[33], users[32], inum
				get_user_name(id, user, 32)
				get_players(users, inum, "c")

				for(new i = 0; i < inum; ++i)
					show_hudmessage(users[i], mg5[lang[users[i]]], user)

				return PLUGIN_HANDLED
			}
		}
	}
	return PLUGIN_CONTINUE 
}
//----------------------------------------------------------------------------------------------
/* SAY_TEAM COMMAND CODE */
public chickenteamsay(id)
{
	if(ChickenTeamTalk && UserFlags[id] && is_user_alive(id) && !is_user_bot(id))
	{
			saying_match(id)
			return PLUGIN_HANDLED
	}
	return PLUGIN_CONTINUE
}
//----------------------------------------------------------------------------------------------
/* SAY/SAY_TEAM CHICKEN CODE */
saying_match(id)
{
	new user[33], ChickenMsg = random(4)
	get_user_name(id, user, 32)
	
	if(ChickenMsg == 0) 
	{
		client_print(0, 3, "%s: buk buk", user)
		chicken_sound(1)
	}
	else if(ChickenMsg == 1) 
	{
		client_print(0, 3, "%s: gu gu gu", user)
		chicken_sound(2)
	}
	else if(ChickenMsg == 2) 
	{
		client_print(0, 3, "%s: ge ge", user)
		chicken_sound(3)
	}
	else
	{
		client_print(0, 3, "%s: gu...ji", user)
		chicken_sound(4)
	}
	return PLUGIN_HANDLED
}
//----------------------------------------------------------------------------------------------
/* SOUND SFX CODE */
chicken_sound(sndno) 
{	
	if(!get_cvar_num("amx_chicken_sfx")) 
		return PLUGIN_HANDLED
	
	new users[32], inum
	get_players(users, inum, "c")
	
	for(new i = 0; i < inum; ++i)
	{
		switch(sndno)
		{
			case 0: client_cmd(users[i], "speak sound/misc/chicken0")
			case 1: client_cmd(users[i], "speak sound/misc/chicken1")
			case 2: client_cmd(users[i], "speak sound/misc/chicken2")
			case 3: client_cmd(users[i], "speak sound/misc/chicken3")
			case 4: client_cmd(users[i], "speak sound/misc/chicken4")
			case 5: client_cmd(users[i], "speak sound/misc/cow")
		}
	}
	return PLUGIN_HANDLED
}
//----------------------------------------------------------------------------------------------
/* SHOW MENU CODE */
public amx_chick_menu(id, level, cid)
{
	if(!cmd_access(id, level, cid, 1))
		return PLUGIN_HANDLED
	
	MenuFlags[id] = 1
	show_chickenmenu(id)
	return PLUGIN_HANDLED
}
//----------------------------------------------------------------------------------------------
show_chickenmenu(id)
{
	new menuoption[10][64], smenu[64], menubody[512]
	new keys = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9)
	for(new z = 0; z < 10; ++z) menuoption[z][0] = 0 // clear string

	switch(MenuFlags[id])  
	{
		case 1: /* Main Menu */
		{
			format(smenu, 63, "%s", mh0[lang[id]])
			format(menuoption[0], 63, "1. %s^n", mh1[lang[id]])
			format(menuoption[1], 63, "2. %s^n", mh2[lang[id]])
			
			if(id && get_user_flags(id) & ACCESS_SETTINGS != ACCESS_SETTINGS)
				keys -= (1<<2)
			
			else
				format(menuoption[2], 63, "3. %s^n", mh3[lang[id]])
			
			format(menuoption[9], 63, "^n0. %s", ex[lang[id]])
			
			keys -= (1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)
		}
		case 2:
		{
			switch(MenuPFlags[id])
			{
				default: /* Players Menu */
				{
					get_players(g_menuPlayers[id], g_menuPlayersNum[id])
					new b = 0, i, user[32], menu = MenuPFlags[id], start = menu * 7

					if(start >= g_menuPlayersNum[id])
						start = MenuPFlags[id] = 0
					
					new len = format(menubody, 511, cstrike_is_running ? "\y[小鸡插件] %s:\R%d/%d^n\w^n" : "[小鸡插件] %s: %d/%d^n^n", 
						mh1[lang[id]], ++menu, (g_menuPlayersNum[id] / 7 + ((g_menuPlayersNum[id] % 7) ? 1 : 0)))
					new pkeys = (1<<8)|(1<<9), end = start + 7 
					
					if(end > g_menuPlayersNum[id])
						end = g_menuPlayersNum[id]
					
					for(new a = start; a < end; ++a)
					{
						i = g_menuPlayers[id][a]
						get_user_name(i, user, 31)
						if(!is_user_alive(i))
						{
							++b   
							if(cstrike_is_running)
								len += format(menubody[len], 511 - len, "\d%d. %s\R%s^n\w", b, user, dd[lang[id]])
							
							else
								len += format(menubody[len], 511 - len, "#. %s %s^n", user, dd[lang[id]])
						}
						else
						{
							pkeys |= (1<<b)
							len += format(menubody[len], 511 - len, cstrike_is_running ? "%d. %s\R\y%s^n\w" : "%d. %s %s^n", ++b, user, UserFlags[i] ? ck[lang[id]] : hm[lang[id]])
						}
					}
					if(end != g_menuPlayersNum[id])
					{
						len += format(menubody[len], 511 - len, "^n8. %s^n^n9. %s^n0. %s", mo[lang[id]], bk[lang[id]], ex[lang[id]])
						pkeys |= (1<<7)
					}
					else
						len += format(menubody[len], 511 - len, "^n9. %s^n0. %s", bk[lang[id]], ex[lang[id]])

					show_menu(id, pkeys, menubody)
				}
			}
			return PLUGIN_HANDLED
		}
		case 3:  /* Team Menu */
		{
			format(smenu, 63, "%s", mh2[lang[id]])
			format(menuoption[0], 63, cstrike_is_running ? "1. %s\R\y%s^n\w" : "1. %s %s^n", Team1, ChickenTeam1 ? yes[lang[id]] : no[lang[id]])
			format(menuoption[1], 63, cstrike_is_running ? "2. %s\R\y%s^n\w" : "2. %s %s^n", Team2, ChickenTeam2 ? yes[lang[id]] : no[lang[id]])
			format(menuoption[2], 63, cstrike_is_running ? "3. %s\R\y%s^n\w" : "3. %s %s^n", m63[lang[id]], ChickenAll ? yes[lang[id]] : no[lang[id]])
			if(cstrike_is_running)
			{
				new map[32]
				get_mapname(map, 31)

				if(!contain(map, "as_"))
					format(menuoption[3], 63, "4. VIP\R\y%s^n\w", ChickenTeam3 ? yes[lang[id]] : no[lang[id]])
			}
			format(menuoption[8], 63, "^n9. %s^n", bk[lang[id]])
			format(menuoption[9], 63, "0. %s", ex[lang[id]])
			
			keys -= (1<<4)|(1<<5)|(1<<6)|(1<<7)
		}
		case 4:  /* Setting Menu 1*/
		{
			format(smenu, 63, "%s", mh3[lang[id]])
			format(menuoption[0], 63, cstrike_is_running ? "1. %s\R\y%s^n\w" : "1. %s %s^n", m71[lang[id]], get_cvar_num("c_bomb") ? on[lang[id]] : off[lang[id]])
			format(menuoption[1], 63, cstrike_is_running ? "2. %s\R\y%s^n\w" : "2. %s %s^n", m72[lang[id]], get_cvar_num("c_egg") ? on[lang[id]] : off[lang[id]])
			format(menuoption[2], 63, cstrike_is_running ? "3. %s\R\y%s^n\w" : "3. %s %s^n", m73[lang[id]], get_cvar_num("c_glow") ? on[lang[id]] : off[lang[id]])
			format(menuoption[3], 63, cstrike_is_running ? "4. %s\R\y%s^n\w" : "4. %s %s^n", m74[lang[id]], HealthProtect ? on[lang[id]] : off[lang[id]])
			format(menuoption[4], 63, cstrike_is_running ? "5. %s\R\y%s^n\w" : "5. %s %s^n", m75[lang[id]], ChickenName ? on[lang[id]] : off[lang[id]])
			format(menuoption[5], 63, cstrike_is_running ? "6. %s\R\y%s^n\w" : "6. %s %s^n", m76[lang[id]], ChickenSelf ? on[lang[id]] : off[lang[id]])
			format(menuoption[6], 63, cstrike_is_running ? "7. %s\R\y%s^n^n\w" : "7. %s %s^n^n", m77[lang[id]], ChickenTalk ? on[lang[id]] : off[lang[id]])
			format(menuoption[7], 63, "8. %s^n^n", mo[lang[id]])
			format(menuoption[8], 63, "9. %s^n", bk[lang[id]])
			format(menuoption[9], 63, "0. %s", ex[lang[id]])
		}
		case 5: /* Setting Menu 2*/
		{
				format(smenu, 63, "%s", mh3[lang[id]])
				format(menuoption[0], 63, cstrike_is_running ? "1. %s\R\y%s^n\w" : "1. %s %s^n", m81[lang[id]], ChickenTeamTalk ? on[lang[id]] : off[lang[id]])
				if(cstrike_is_running)
					format(menuoption[1], 63, ChickenSelf ? "2. %s\R\y%i^n\w" : "\d2. %s\R%i^n\w", m82[lang[id]], ChickenHP)
				else
					format(menuoption[1], 63, "2. %s %i^n", m82[lang[id]], ChickenHP)
				format(menuoption[2], 63, cstrike_is_running ? "3. %s\R\y%i^n\w" : "3. %s %i^n", m83[lang[id]], get_cvar_num("c_health"))
				format(menuoption[3], 63, cstrike_is_running ? "4. %s\R\y%i^n\w" : "4. %s %i^n", m84[lang[id]], get_cvar_num("c_gravity"))
				format(menuoption[4], 63, cstrike_is_running ? "5. %s\R\y%i^n\w" : "5. %s %i^n", m85[lang[id]], get_cvar_num("c_maxspeed"))
				format(menuoption[5], 63, cstrike_is_running ? "6. %s\R\y%i^n\w" : "6. %s %i^n", m86[lang[id]], ChickenVision)
				format(menuoption[6], 63, cstrike_is_running ? "7. %s\R\y%s^n^n\w" : "7. %s %s^n^n", m87[lang[id]], get_cvar_num("amx_chicken_sfx") ? on[lang[id]] : off[lang[id]])
				format(menuoption[8], 63, "9. %s^n", bk[lang[id]])
				format(menuoption[9], 63, "0. %s", ex[lang[id]])
				
				keys -= (1<<7)
		}
	}
	format(menubody, 511, cstrike_is_running ? "\y[小鸡插件] %s:\w^n^n%s%s%s%s%s%s%s%s%s%s" : "[小鸡插件] %s:^n^n%s%s%s%s%s%s%s%s%s%s", 
		smenu, menuoption[0], menuoption[1], menuoption[2], menuoption[3], menuoption[4], 
		menuoption[5], menuoption[6], menuoption[7], menuoption[8], menuoption[9])
	show_menu(id, keys, menubody)
	return PLUGIN_HANDLED
}
//----------------------------------------------------------------------------------------------
/* ACTION MENU CODE */
public action_chickenmenu(id, key)   
{
	if(MenuFlags[id] == 1)
	{
		switch(key)
		{
			case 0: MenuFlags[id] = 2  // PLAYERS MENU BUTTON (1)
			case 1: MenuFlags[id] = 3 // TEAM MENU BUTTON (2)
			case 2: MenuFlags[id] = 4 // SETTINGS MENU BUTTON (3)
			case 9: // EXIT BUTTON (0)
			{
				// Menu Fix (Popup)
				MenuFlags[id] = 0
				return PLUGIN_HANDLED
			}
		}
		// Bypass Update System
		show_chickenmenu(id)
		return PLUGIN_HANDLED
	}
	else if(MenuFlags[id] == 2)
	{
		switch(key)
		{
			case 7: // MORE BUTTON (8)
			{
				++MenuPFlags[id]
				// Bypass Update System
				show_chickenmenu(id)
				return PLUGIN_HANDLED
			}
			case 8: // BACK BUTTON (9)
			{
				if(MenuPFlags[id] > 0)
				{
					// Bypass Update System
					--MenuPFlags[id]
					show_chickenmenu(id)
					return PLUGIN_HANDLED
				}
				else
				{
					// Bypass Update System
					MenuFlags[id] = 1
					show_chickenmenu(id)
					return PLUGIN_HANDLED
				}
			}
			case 9: // EXIT BUTTON (0)
			{
				// Menu Fix (Popup)
				MenuFlags[id] = 0
				return PLUGIN_HANDLED
			}
			default:
			{
				new player = g_menuPlayers[id][MenuPFlags[id] * 7 + key]
				new user[33], users[32], inum
				get_user_name(player, user, 32)
				get_players(users, inum, "c")
				
				if(UserFlags[player])
				{
					unchicken_user(player)
					set_hudmessage(255, 25, 255, 0.05, 0.65, 2, 0.1, 4.0, 0.02, 0.02, 10)
					
					if(get_cvar_num("amx_chicken_sfx"))
						emit_sound(player, CHAN_ITEM, "misc/cow.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
					
					for(new i = 0; i < inum; ++i)
						show_hudmessage(users[i], mg6[lang[users[i]]], user)
				}
				else 
				{
					chicken_user(player)
					set_hudmessage(255, 25, 255, 0.05, 0.65, 2, 0.1, 4.0, 0.02, 0.02, 10)

					if(get_cvar_num("amx_chicken_sfx"))
						emit_sound(player, CHAN_ITEM, "misc/chicken0.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
					
					for(new i = 0; i < inum; ++i)
						show_hudmessage(users[i], mg7[lang[users[i]]], user)
				}
			}
		}
	}
	else if(MenuFlags[id] == 3)
	{
		new users[32], inum
		get_players(users, inum, "a")
		switch(key)
		{
			case 0:
			{
				if(ChickenTeam1 == false)
				{
					ChickenTeam1 = true
					for(new i = 0; i < inum; ++i)
					{
						if(get_user_team(users[i]) == 1)
							chicken_user(users[i])
						
						if(get_cvar_num("amx_chicken_sfx"))
							chicken_sound(0)
						
						set_hudmessage(255, 25, 255, 0.05, 0.65, 2, 0.1, 4.0, 0.02, 0.02, 10)
						show_hudmessage(users[i], mg8[lang[users[i]]], Team1)
					}
				}
				else
				{
					ChickenTeam1 = false
					for(new i = 0; i < inum; ++i) 
					{
						if(get_user_team(users[i]) == 1)
							unchicken_user(users[i])
						
						if(get_cvar_num("amx_chicken_sfx"))
							chicken_sound(5)
						
						set_hudmessage(255, 25, 255, 0.05, 0.65, 2, 0.1, 4.0, 0.02, 0.02, 10)
						show_hudmessage(users[i], mg9[lang[users[i]]], Team1)
					}
				}
			}
			case 1:
			{
				if(ChickenTeam2 == false)
				{
					ChickenTeam2 = true
					for(new i = 0; i < inum; ++i)
					{
						if(get_user_team(users[i]) == 2)
							chicken_user(users[i])

						if(get_cvar_num("amx_chicken_sfx"))
							chicken_sound(0)
						
						set_hudmessage(255, 25, 255, 0.05, 0.65, 2, 0.1, 4.0, 0.02, 0.02, 10)
						show_hudmessage(users[i], mg8[lang[users[i]]], Team2)
					}
				}
				else
				{
					ChickenTeam2 = false
					for(new i = 0; i < inum; ++i)
					{
						if(get_user_team(users[i]) == 2)
							unchicken_user(users[i])
						
						if(get_cvar_num("amx_chicken_sfx"))
							chicken_sound(5)
						
						set_hudmessage(255, 25, 255, 0.05, 0.65, 2, 0.1, 4.0, 0.02, 0.02, 10)
						show_hudmessage(users[i], mg9[lang[users[i]]], Team2)
					}
				}
			}
			case 2:
			{
				if(ChickenAll == false)
				{
					ChickenAll = true
					for(new i = 0; i < inum; ++i) 
					{
						chicken_user(users[i])
						
						if(get_cvar_num("amx_chicken_sfx"))
							chicken_sound(0)
						
						set_hudmessage(255, 25, 255, 0.05, 0.65, 2, 0.1, 4.0, 0.02, 0.02, 10)
						show_hudmessage(users[i], mg10[lang[users[i]]])
					}
				}
				else
				{
					ChickenAll = false
					for(new i = 0; i < inum; ++i) 
					{
						unchicken_user(users[i])
						
						if(get_cvar_num("amx_chicken_sfx"))
							chicken_sound(5)
						
						set_hudmessage(255, 25, 255, 0.05, 0.65, 2, 0.1, 4.0, 0.02, 0.02, 10)
						show_hudmessage(users[i], mg11[lang[users[i]]])
					}
				}
			}
			case 3:
			{
				if(cstrike_is_running)
				{
					new map[32]
					get_mapname(map, 31)
					
					if(!contain(map, "as_"))
					{
						if(ChickenTeam3 == false)
						{
							ChickenTeam3 = true
							chicken_user(Team3)
							
							if(get_cvar_num("amx_chicken_sfx"))
								emit_sound(Team3, CHAN_ITEM, "misc/chicken0.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
						}
						else if(ChickenTeam3)
						{
							ChickenTeam3 = false
							unchicken_user(Team3)
							
							if(get_cvar_num("amx_chicken_sfx"))
								emit_sound(Team3, CHAN_ITEM, "misc/cow.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
						}
					}
				}
			}
			case 8: // BACK BUTTON (9)
			{
				// Bypass Update System
				MenuFlags[id] = 1
				show_chickenmenu(id)
				return PLUGIN_HANDLED
			}
			case 9: // EXIT BUTTON (0)
			{
				// Menu Fix (Popup)
				MenuFlags[id] = 0
				return PLUGIN_HANDLED
			}
		}
	}
	else if(MenuFlags[id] == 4)
	{
		switch(key)
		{
			case 0:
			{
				if(cstrike_is_running)
					get_cvar_num("c_bomb") ? set_cvar_num("c_bomb", 0) : set_cvar_num("c_bomb", 1)
			}
			case 1:
			{
				if(cstrike_is_running)
					get_cvar_num("c_egg") ? set_cvar_num("c_egg", 0) : set_cvar_num("c_egg", 1)
			}
			case 2:
				get_cvar_num("c_glow") ? set_cvar_num("c_glow", 0) : set_cvar_num("c_glow", 1)

			case 3:
				HealthProtect ? HealthProtect = false : HealthProtect = true

			case 4:
				ChickenName ? ChickenName = false : ChickenName = true

			case 5:
				ChickenSelf ? ChickenSelf = false : ChickenSelf = true

			case 6:
				ChickenTalk ? ChickenTalk = false : ChickenTalk = true

			case 7: // MORE BUTTON (8)
			{
				// Bypass Update System
				MenuFlags[id] = 5
				show_chickenmenu(id)
				return PLUGIN_HANDLED
			}
			case 8: // BACK BUTTON (9)
			{
				// Bypass Update System
				MenuFlags[id] = 1
				show_chickenmenu(id)
				return PLUGIN_HANDLED
			}
			case 9: // EXIT BUTTON (0)
			{
				// Menu Fix (Popup)
				MenuFlags[id] = 0
				return PLUGIN_HANDLED
			}
		}
	}
	else if(MenuFlags[id] == 5)
	{
		switch(key)
		{
			case 0:
				ChickenTeamTalk ? ChickenTeamTalk = false : ChickenTeamTalk = true

			case 1:
			{
				if(!ChickenSelf)
				{
					// Bypass Update System
					show_chickenmenu(id)
					return PLUGIN_HANDLED
				}
				else if(ChickenHP + MenuGrv > 100 || ChickenHP > 100)
					ChickenHP = 0
				
				else
					ChickenHP += MenuGrv
			}
			case 2:
			{
				new health = get_cvar_num("c_health")
				
				if(HealthProtect)
				{
					if(health + MenuHP > 255 || health > 255) 
						set_cvar_num("c_health", 0)
					
					else
						set_cvar_num("c_health", health += MenuHP)
				}
				else 
					set_cvar_num("c_health", health += MenuHP) 
			}
			case 3:
			{
				new gravity = get_cvar_num("c_gravity")
				
				if(gravity + MenuGrv > 100 || gravity > 100) 
					set_cvar_num("c_gravity", 0)
				
				else
					set_cvar_num("c_gravity", gravity += MenuGrv)
			}
			case 4:
			{
				new speed = get_cvar_num("c_maxspeed")
				
				if(speed + MenuSpd > 400 || speed > 400) 
					set_cvar_num("c_maxspeed", 0)
				
				else
					set_cvar_num("c_maxspeed", speed += MenuSpd)
			}
			case 5:
			{
				if(ChickenVision + MenuGrv > 255 || ChickenVision > 255) 
					ChickenVision = 0
				
				else 
					ChickenVision += MenuGrv
			}
			case 6:
			{
				get_cvar_num("amx_chicken_sfx") ? set_cvar_num("amx_chicken_sfx", 0) : set_cvar_num("amx_chicken_sfx", 1)
			}
			case 8: // BACK BUTTON (9)
			{
				// Bypass Update System
				MenuFlags[id] = 4
				show_chickenmenu(id)
				return PLUGIN_HANDLED
			}
			case 9: // EXIT BUTTON (0)
			{
				// Menu Fix (Popup)
				MenuFlags[id] = 0
				return PLUGIN_HANDLED
			}
		}
	}
	update_menu()
	return PLUGIN_HANDLED
}
//----------------------------------------------------------------------------------------------
/* MENU UPDATER */
update_menu()
{
	new admins[32], inum
	get_players(admins, inum)
	for(new i = 0; i < inum; ++i)
		if(MenuFlags[admins[i]] > 0)
			show_chickenmenu(admins[i])
}
//----------------------------------------------------------------------------------------------
public get_weapon(id)
{
	if(UserFlags[id])
	{
		new ammo, clip, wid 
		wid = get_user_weapon(id, clip, ammo) 
		if(wid != 29) 
			engclient_cmd(id, "weapon_knife")
	}
}
//----------------------------------------------------------------------------------------------
/* VIP DETECTION CODE */
public detect_vip(id)
{
	Team3 = id
	if(ChickenTeam3 && UserFlags[id] == false) 
		chicken_user(id)
}
//----------------------------------------------------------------------------------------------
/* DEATH EVENT CODE */
public death_event(id) 
	update_menu()
//----------------------------------------------------------------------------------------------
/* FIELD OF VIEW EVENT CODE */
public check_fov(id) 
	if(UserFlags[id]) 
		set_vision(id)
//----------------------------------------------------------------------------------------------
/* RESETHUD EVENT CODE */
public chicken_update(id) 
{
	if(UserFlags[id])
		set_task(1.0, "set_hitzones", id)
	
	new team = get_user_team(id)
	
	if(ChickenTeam1)
		if(1 == team && UserFlags[id] == false) 
			chicken_user(id)
	
	if(ChickenTeam2)
		if(2 == team && UserFlags[id] == false)
			chicken_user(id)
	
	if(ChickenAll)
		if(0 > team && 5 < team)
			if(UserFlags[id] == false) chicken_user(id)
	
	update_menu()
}
//----------------------------------------------------------------------------------------------
/* CONNECTION CODE */
public client_putinserver(id)
	update_menu()

public client_connect(id)
	lang_set(id)
//----------------------------------------------------------------------------------------------
/* INFO CHANGE CODE */
public client_infochanged(id)
{
	/* LANGUAGE CHECK */
	lang_set(id)

	if(ChickenName && UserFlags[id] && !is_user_bot(id))
	{
		new newname[33], oldname[33]
		get_user_info(id, "name", newname, 32)
		get_user_name(id, oldname, 32)
		
		if(!equal(oldname, newname))
			set_user_info(id, "name", ChickName[id])
	}
	update_menu()
}
//----------------------------------------------------------------------------------------------
/* DISCONNECT CODE */
public client_disconnect(id)
{
	if(UserFlags[id])
		UserFlags[id] = false
	
	if(MenuFlags[id] > 0)
		MenuFlags[id] = 0

	update_menu()
}
//----------------------------------------------------------------------------------------------
/* END CODE */
public plugin_end()
{
	new users[32], inum
	get_players(users, inum)
	for(new i = 0; i < inum; ++i)
		if(UserFlags[users[i]])
			unchicken_user(users[i])
}
//----------------------------------------------------------------------------------------------
/* PRECACHE CODE */
public plugin_precache()
{
	precache_sound("misc/chicken0.wav")
	precache_sound("misc/cow.wav")
}
//----------------------------------------------------------------------------------------------
/* INITIATION CODE */
public plugin_init()
{
	register_plugin("AMXModX Chicken", "Build #3.0", "[小鸡插件] Dev")

	cstrike_is_running = is_running("cstrike") ? true : false

	loadcfg("addons/amxmodx/configs/chicken.cfg")
	
	register_menucmd(register_menuid("\y[小鸡插件]"), 1023, "action_chickenmenu")
	if(cstrike_is_running) register_event("Battery", "detect_vip", "b", "1=200")
	if(cstrike_is_running == false) register_event("CurWeapon", "get_weapon", "b")
	gmsgSetFOV = get_user_msgid("SetFOV")
	register_event("SetFOV", "check_fov", "be", "1=90")	
	register_event("DeathMsg", "death_event", "a")
	register_event("ResetHUD", "chicken_update", "b")
	
	cstrike_is_running ? register_clcmd("amx_chicken", "amx_chicken", ACCESS_MENU, "<authid, nick, #userid, @1/2/3 (1 = Terrorists, 2 = Counter-Terrorists, 3 = VIP) or * (all)>") : register_clcmd("amx_chicken", "amx_chicken", ACCESS_MENU, "<authid, nick, #userid, @1/2 (1 = Team1, 2 = Team2) or * (all)>")
	cstrike_is_running ? register_clcmd("amx_unchicken", "amx_unchicken", ACCESS_MENU, "<authid, nick, #userid, @1/2/3 (1 = Terrorists, 2 = Counter-Terrorists, 3 = VIP) or * (all)>") : register_clcmd("amx_chicken", "amx_chicken", ACCESS_MENU, "<authid, nick, #userid, @1/2 (1 = Team1, 2 = Team2) or * (all)>")
	register_clcmd("amx_chick_menu", "amx_chick_menu", ACCESS_MENU, "- [小鸡插件]: User Interface")
	register_clcmd("say /chickenmenu", "amx_chick_menu", ACCESS_MENU, "- [小鸡插件]: User Interface")
	register_clcmd("say", "chickensay")
	register_clcmd("say_team", "chickenteamsay")
	register_clcmd("say /chickenme", "chickensay", 0, "- chicken yourself")
	register_clcmd("say /unchickenme", "chickensay", 0, "- unchicken yourself")
	register_cvar("amx_chicken_sfx", "1")
	
	server_cmd("exec addons/amxmodx/configs/chicken.cfg")
	/* DISPLAY IN LANGUAGE MENU */
	lang_register("AMXModX Chicken Build #3.0")
	AddMenuItem("小鸡插件", "amx_chick_menu", ADMIN_CFG, "AMXModX Chicken")
}
//----------------------------------------------------------------------------------------------
/* LOAD/READ CONFIG CODE */
loadcfg(filename[])
{
	if(file_exists(filename))
	{
		new readdata[100]
		new set[30], val[30], len
		for(new i = 0; i < 100 && read_file(filename, i, readdata, 99, len); ++i)
		{
			parse(readdata, set, 29, val, 29)
			if(equal(set, "Team1")) copy(Team1, 29, val)
			if(equal(set, "Team2")) copy(Team2, 29, val)
			if(equal(set, "ChickenVision")) ChickenVision = str_to_num (val)
			if(equal(set, "HealthProtect")) if(!equal(val, "1")) HealthProtect = false
			if(equal(set, "ChickenName")) if(!equal(val, "1")) ChickenName = false
			if(equal(set, "ChickenSelf")) if(!equal(val, "1")) ChickenSelf = false
			if(equal(set, "ChickenHP")) ChickenHP = str_to_num (val)
			if(equal(set, "ChickenTalk")) if(!equal(val, "1")) ChickenTalk = false
			if(equal(set, "ChickenTeamTalk")) if(!equal(val, "1")) ChickenTeamTalk = false
			if(equal(set, "ChickenBomb")) if(!equal(val, "0")) set_cvar_num("c_bomb", 1)
			if(equal(set, "ChickenGrenades")) if(!equal(val, "1")) set_cvar_num("c_egg", 0)
			if(equal(set, "ChickenGlow")) if(!equal(val, "1")) set_cvar_num("c_glow", 0)
			if(equal(set, "ChickenHealth"))
			{
				if(HealthProtect)
				{
					if(str_to_num (val) > 255) set_cvar_num("c_health", 255)
					else set_cvar_num("c_health", str_to_num (val))
				}
				else set_cvar_num("c_health", str_to_num (val))
			}
			if(equal(set, "ChickenGravity"))
			{
				if(str_to_num (val) > 100) set_cvar_num("c_gravity", 100)
				else set_cvar_num("c_gravity", str_to_num (val))
			}
			if(equal(set, "ChickenSpeed")) 
			{
				if(str_to_num (val) > 400) set_cvar_num("c_maxspeed", 400)
				else set_cvar_num("c_maxspeed", str_to_num (val))
			}
			if(equal(set, "MenuGrv")) MenuGrv = str_to_num (val)
			if(equal(set, "MenuHP")) MenuHP = str_to_num (val)
			if(equal(set, "MenuSpd")) MenuSpd = str_to_num (val)
			if(equal(set, "ACCESS_MENU")) ACCESS_MENU = str_to_num (val)
			if(equal(set, "ACCESS_SETTINGS")) ACCESS_SETTINGS = str_to_num (val)
		}
	}
	return PLUGIN_HANDLED
}